/***************************************************************************/
/**                                                                       **/
/**     b  i  o  l  o  g  i  c  a  l  N  f  i  x  a  t  i  o  n  .  c     **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Guilaume Vilain, Christoph Mueller                     **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-01-12 13:48:51 +0100 (Thu, 12 Jan 201#$ **/
/**     By         : $Author:: cmueller                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"
#include "tree.h"
//#include "crop.h"

Real biologicalnfixation(const Stand *stand /* pointer to stand */
                        )                   /* returns N fixation rate (gN/m2/d) */                
{
  const Pft *pft;
  const Pftgrass *grass;
  const Pfttree *tree;
  //const Pftcrop *crop;
  int p;
  Real bnf=0;

  foreachpft(pft,p,&stand->pftlist)
    switch(pft->par->type)
    {
      case TREE:
        tree=pft->data;
        if(tree->ind.root.carbon>param.min_c_bnf)
          bnf+=max(0,(0.0234*stand->cell->climbuf.aetp_mean-0.172)/10/NDAYYEAR)*pft->fpc;
        break;
      case GRASS:
        grass=pft->data;
        if(grass->ind.root.carbon>param.min_c_bnf)
          bnf+=max(0,(0.0234*stand->cell->climbuf.aetp_mean-0.172)/10/NDAYYEAR)*pft->fpc;
        break;
        // N fixation for crops now in n_uptake_crop.c
      /*case CROP:
        if(pft->par->id==PULSES || pft->par->id==OIL_CROPS_SOYBEAN)
        {
          crop=pft->data;
          if(crop->ind.root.carbon>param.min_c_bnf)
            bnf+=max(0,(0.0234*stand->cell->climbuf.aetp_mean-0.172)/10/NDAYYEAR)*pft->fpc;
        }
        break;
        */
    } /* of switch */
  return bnf;
} /* of 'biologicalnfixation' */

/* based on Cleveland, 1999                                               */
/* allow only for natural vegetation and grassland and pulses and soybean */
/* allow only if minimum root biomass is available.                       */
/* first approximation to avoid BNF in areas with no vegetation           */
/* later extend to Fisher et al. 2010 approach                            */
