/***************************************************************************/
/**                                                                       **/
/**                a  d  d  l  i  t  t  e  r  .  c                        **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**     Function adds PFT-specific above ground litter pool               **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-09-04 18:28:02 +0200 (Mon, 04 Sep 201#$ **/
/**     By         : $Author:: heinke                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

int addlitter(Litter *litter,const Pftpar *pft)
{
  int i;
  litter->ag=(Litteritem *)realloc(litter->ag,
                                   sizeof(Litteritem)*(litter->n+1));
  check(litter->ag);
  litter->agsub = (Litteritem *)realloc(litter->agsub,
                                   sizeof(Litteritem)*(litter->n+1));
  check(litter->agsub);
  litter->bg=(Stocks *)realloc(litter->bg,
                                   sizeof(Stocks)*(litter->n+1));
  check(litter->bg);
  litter->ag[litter->n].pft=pft;
  litter->ag[litter->n].trait.leaf.carbon=0;
  litter->ag[litter->n].trait.leaf.nitrogen=0;
  litter->agsub[litter->n].pft=pft;
  litter->agsub[litter->n].trait.leaf.carbon=0;
  litter->agsub[litter->n].trait.leaf.nitrogen=0;
  for(i=0;i<NFUELCLASS;i++)
  {
    litter->ag[litter->n].trait.wood[i].carbon=litter->ag[litter->n].trait.wood[i].nitrogen=0;
    litter->agsub[litter->n].trait.wood[i].carbon=litter->agsub[litter->n].trait.wood[i].nitrogen=0;
  }
  litter->bg[litter->n].carbon=litter->bg[litter->n].nitrogen=0;
  litter->n++;
  return litter->n;
} /* of 'addlitter' */
