/***************************************************************************/
/**                                                                       **/
/**          f  p  r  i  n  t  r  e  s  d  a  t  a  .  c                  **/
/**                                                                       **/
/**     Function prints reservoir data to text file                       **/
/**                                                                       **/
/**     written by Hester Biemans and Werner von Bloh                     **/
/**     Wageningen University and Research Centre                         **/
/**     and                                                               **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2015-11-11 13:03:35 +0100 (Wed, 11 Nov 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

static void fprinthist(FILE *file,Real hist[HIST_YEARS][NMONTH])
{
  int i,j;
  fputs("Year",file);
  for(j=0;j<NMONTH;j++)
    fprintf(file," %-6s",months[j]);
  fputc('\n',file);
  for(i=0;i<HIST_YEARS;i++)
  {
    fprintf(file,"%4d",i);
    for(j=0;j<NMONTH;j++)
      fprintf(file," %6.1f",hist[i][j]);
    fputc('\n',file);
  }
} /* of 'fprinthist' */

void fprintresdata(FILE *file,const Cell *cell)
{
  fprintf(file,"Reservoir frac:\t%g\n"
               "pool:\t%g (gC/m2) %g (gN/m2)\n"
               "meand demand:\t%g\n"
               "mean inflow:\t%g\n"
               "water mass:\t%g\n" 
               "k_rls:\t%g\n",
          cell->ml.reservoirfrac,cell->ml.resdata->pool.carbon,cell->ml.resdata->pool.nitrogen,
          cell->ml.resdata->mean_demand,cell->ml.resdata->mean_inflow,
          cell->ml.resdata->dmass,cell->ml.resdata->k_rls);
  fputs("demand history:\n",file);
  fprinthist(file,cell->ml.resdata->demand_hist);
  fputs("inflow history:\n",file);
  fprinthist(file,cell->ml.resdata->inflow_hist);
  fputs("level history:\n",file);
  fprinthist(file,cell->ml.resdata->level_hist);
} /* of 'fprintresdata' */
