/***************************************************************************/
/**                                                                       **/
/**                  i  n  t  e  r  p  o  l  a  t  e  .  c                **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Interpolation function in order to get daily values from monthly  **/
/**     data                                                              **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-10-07 11:15:16 +0200 (Fri, 07 Oct 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include <stdio.h>
#include "types.h"
#include "date.h"

Real interpolate(const MReal mval, /* monthly values to interpolate        */
                 int month,        /* month (0..11)                        */
                 int dm            /* day of month (0..ndaymonth[month]-1) */
                )                  /* returns interpolated value           */
{
  int nextmonth;
  Real diff;
#ifdef DEBUG3
  printf("dm=%d,month=%d,ndaymonth=%d\n",dm,month,ndaymonth[month]);
#endif
  if(dm>=ndaymonth[month]/2)
  {
    dm-=ndaymonth[month]/2;
    nextmonth=(month<NMONTH-1) ? month+1 : 0;
  }
  else
  {
    nextmonth=month;
    if(month==0)
      month=NMONTH-1;
    else
      month--; 
    dm+=ndaymonth[month]/2+ndaymonth[month] %2 ; 
  }
  diff=1.0/(ndaymonth[month]/2+ndaymonth[nextmonth]/2+ndaymonth[month] %2 );
#ifdef DEBUG3
  printf("mval[%d]=%g,mval[%d]=%g,dm=%d,diffday=%g,%d\n",month,mval[month],
         nextmonth,mval[nextmonth],dm,1/diff,ndaymonth[month]);
  printf("res=%g\n",mval[month]+dm*(mval[nextmonth]-mval[month])*diff);
#endif

  return mval[month]+dm*(mval[nextmonth]-mval[month])*diff;
} /* of 'interpolate' */
