/***************************************************************************/
/**                                                                       **/
/**    c  l  o  s  e  c  l  i  m  a  t  e  _  n  e  t  c  d  f  .  c      **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function closes climate data file in NetCDF format                **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2014-10-01 15:08:01 +0200 (Wed, 01 Oct 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void closeclimate_netcdf(Climatefile *file,Bool isroot)
{
#if defined(USE_NETCDF) || defined(USE_NETCDF4)
  if(file->oneyear)
    free(file->filename);
  else if(isroot)
    free_netcdf(file->ncid);
#endif
} /* of 'closeclimate_netcdf' */
