/***************************************************************************/
/**                                                                       **/
/**   u  p  d  a  t  e  _  o  u  t  p  u  t  m  o  n  t  h  l  y  .  c    **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2018-02-11 21:15:17 +0100 (Sun, 11 Feb 201#$ **/
/**     By         : $Author:: felutz                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void update_outputmonthly(Outputmonth *output,
                          const Output *data,
                          int total,
                          int month)
{
  if(output->mnpp!=NULL)
    output->mnpp[output->count+month*total]=(float)data->mnpp;
  if(output->mgpp!=NULL)
    output->mgpp[output->count+month*total]=(float)data->mgpp;
  if(output->mrh!=NULL)
    output->mrh[output->count+month*total]=(float)data->mrh;
  if(output->mfpar!=NULL)
    output->mfpar[output->count+month*total]=(float)data->mfpar;
  if(output->mrunoff!=NULL)
    output->mrunoff[output->count+month*total]=(float)data->mrunoff;
  if(output->mdischarge!=NULL)
    output->mdischarge[output->count+month*total]=(float)data->mdischarge;
  if(output->mwateramount!=NULL)
    output->mwateramount[output->count+month*total]=(float)data->mwateramount;
  if(output->mevap!=NULL)
    output->mevap[output->count+month*total]=(float)data->mevap;
  if(output->mevap_b!=NULL)
    output->mevap_b[output->count+month*total]=(float)data->mevap_b;
  if(output->mtransp!=NULL)
    output->mtransp[output->count+month*total]=(float)data->mtransp;
  if(output->mtransp_b!=NULL)
    output->mtransp_b[output->count+month*total]=(float)data->mtransp_b;
  if(output->minterc!=NULL)
    output->minterc[output->count+month*total]=(float)data->minterc;
  if(output->mwd_local!=NULL)
    output->mwd_local[output->count+month*total]=(float)data->mwd_local;
  if(output->mwd_neighb!=NULL)
    output->mwd_neighb[output->count+month*total]=(float)data->mwd_neighb;
  if(output->mwd_res!=NULL)
    output->mwd_res[output->count+month*total]=(float)data->mwd_res;
  if(output->minterc_b!=NULL)
    output->minterc_b[output->count+month*total]=(float)data->minterc_b;
  if(output->mconv_loss_evap!=NULL)
    output->mconv_loss_evap[output->count+month*total]=(float)data->mconv_loss_evap;
  if(output->mconv_loss_drain!=NULL)
    output->mconv_loss_drain[output->count+month*total]=(float)data->mconv_loss_drain;
  if(output->mstor_return!=NULL)
    output->mstor_return[output->count+month*total]=(float)data->mstor_return;
  if(output->mpet!=NULL)
    output->mpet[output->count+month*total]=(float)data->mpet;
  if(output->mswc1!=NULL)
    output->mswc1[output->count+month*total]=(float)data->mswc[0];
  if(output->mswc2!=NULL)
    output->mswc2[output->count+month*total]=(float)data->mswc[1];
  if(output->mswc3!=NULL)
    output->mswc3[output->count+month*total]=(float)data->mswc[2];
  if(output->mswc4!=NULL)
    output->mswc4[output->count+month*total]=(float)data->mswc[3];
  if(output->mswc5!=NULL)
    output->mswc5[output->count+month*total]=(float)data->mswc[4];
  if(output->mrootmoist!=NULL)
    output->mrootmoist[output->count+month*total]=(float)data->mrootmoist;
  if(output->mirrig!=NULL)
    output->mirrig[output->count+month*total]=(float)data->mirrig;
  if(output->mreturn_flow_b!=NULL)
    output->mreturn_flow_b[output->count+month*total]=(float)data->mreturn_flow_b;
  if(output->mwd_local!=NULL)
	  output->mwd_local[output->count+month*total]=(float)data->mwd_local;
  if(output->mwd_neighb!=NULL)
	  output->mwd_neighb[output->count+month*total]=(float)data->mwd_neighb;
  if(output->mwd_res!=NULL)
 	  output->mwd_res[output->count+month*total]=(float)data->mwd_res;
  if(output->mevap_lake!=NULL)
    output->mevap_lake[output->count+month*total]=(float)data->mevap_lake;
  if(output->mfirec!=NULL)
    output->mfirec[output->count+month*total]=(float)data->mfirec;
  if(output->mnfire!=NULL)
    output->mnfire[output->count+month*total]=(float)data->mnfire;
  if(output->mfiredi!=NULL)
    output->mfiredi[output->count+month*total]=(float)data->mfiredi;
  if(output->mfireemission!=NULL)
    output->mfireemission[output->count+month*total]=(float)data->mfireemission;
  if(output->msoilc1!=NULL)
    output->msoilc1[output->count + month*total] = (float)data->msoilc1;
   if(output->msoiltemp1!=NULL)
    output->msoiltemp1[output->count+month*total]=(float)data->msoiltemp1;
   if(output->msoiltemp2!=NULL)
    output->msoiltemp2[output->count+month*total]=(float)data->msoiltemp2;
   if(output->msoiltemp3!=NULL)
    output->msoiltemp3[output->count+month*total]=(float)data->msoiltemp3;
   if(output->msoiltemp4!=NULL)
    output->msoiltemp4[output->count+month*total]=(float)data->msoiltemp4;
   if(output->msoiltemp5!=NULL)
    output->msoiltemp5[output->count+month*total]=(float)data->msoiltemp5;
   if(output->msoiltemp6!=NULL)
    output->msoiltemp6[output->count+month*total]=(float)data->msoiltemp6;
  if(output->mburntarea!=NULL)
    output->mburntarea[output->count+month*total]=(float)data->mburntarea;
  if(output->mtemp_image!=NULL)
    output->mtemp_image[output->count+month*total]=(float)data->mtemp_image;
  if(output->mprec_image!=NULL)
    output->mprec_image[output->count+month*total]=(float)data->mprec_image;
  if(output->mwet_image!=NULL)
    output->mwet_image[output->count+month*total]=(float)data->mwet_image;
  if(output->msun_image!=NULL)
    output->msun_image[output->count+month*total]=(float)data->msun_image;
  if(output->mprec!=NULL)
    output->mprec[output->count+month*total]=(float)data->mprec;
  if(output->msnowf!=NULL)
    output->msnowf[output->count+month*total]=(float)data->msnowf;
  if(output->mrain!=NULL)
    output->mrain[output->count+month*total]=(float)data->mrain;
  if(output->mmelt!=NULL)
    output->mmelt[output->count+month*total]=(float)data->mmelt;
  if(output->msnowrunoff!=NULL)
    output->msnowrunoff[output->count+month*total]=(float)data->msnowrunoff;
  if(output->mswe!=NULL)
    output->mswe[output->count+month*total]=(float)data->mswe;
  if(output->mseepage!=NULL)
    output->mseepage[output->count+month*total]=(float)data->mseepage;
  if(output->mrunoff_surf!=NULL)
    output->mrunoff_surf[output->count+month*total]=(float)data->mrunoff_surf;
  if(output->mrunoff_lat!=NULL)
    output->mrunoff_lat[output->count+month*total]=(float)data->mrunoff_lat;
  if(output->mgcons_rf!=NULL)
    output->mgcons_rf[output->count+month*total]=(float)data->mgcons_rf;
  if(output->mgcons_irr!=NULL)
    output->mgcons_irr[output->count+month*total]=(float)data->mgcons_irr;
  if(output->mbcons_irr!=NULL)
    output->mbcons_irr[output->count+month*total]=(float)data->mbcons_irr;
  if(output->mbnf!=NULL)
    output->mbnf[output->count+month*total]=(float)data->mbnf;
  if(output->mn2o_denit!=NULL)
    output->mn2o_denit[output->count+month*total]=(float)data->mn2o_denit;
  if(output->mn2o_nit!=NULL)
    output->mn2o_nit[output->count+month*total]=(float)data->mn2o_nit;
  if(output->mn2_emissions!=NULL)
    output->mn2_emissions[output->count+month*total]=(float)data->mn2_emissions;
  if(output->mn_leaching!=NULL)
    output->mn_leaching[output->count+month*total]=(float)data->mn_leaching;
  if(output->mn_uptake!=NULL)
    output->mn_uptake[output->count+month*total]=(float)data->mn_uptake;
  if(output->mn_mineralization!=NULL)
    output->mn_mineralization[output->count+month*total]=(float)data->mn_mineralization;
  if(output->mn_volatilization!=NULL)
    output->mn_volatilization[output->count+month*total]=(float)data->mn_volatilization;
  if(output->mn_immo!=NULL)
    output->mn_immo[output->count+month*total]=(float)data->mn_immo;
  if(output->mirrig_rw!=NULL)
    output->mirrig_rw[output->count+month*total]=(float)data->mirrig_rw;
  if(output->munmet_demand!=NULL)
    output->munmet_demand[output->count+month*total]=(float)data->munmet_demand;
} /* of 'update_outputmonthly' */
