/***************************************************************************/
/**                                                                       **/
/**                s  t  a  n  d  s  t  o  c  k  s  .  c                  **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function computes total carbon and nitrogen in stand              **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2014-07-11 14:41:21 +0200 (Fri, 11 Jul 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Stocks standstocks(const Stand *stand /* pointer to stand */
                  )                   /* returns stocks sum (gC/m2,gN/m2) */
{
  int p;
  const Pft *pft;
  Stocks tot;
  tot=soilstocks(&stand->soil); /* get stocks in soil */
  foreachpft(pft,p,&stand->pftlist)
  {
    tot.carbon+=vegc_sum(pft); /* sum up carbon in PFTs */
    tot.nitrogen+=vegn_sum(pft); /* sum up nitrogen in PFTs */
  }
  return tot;
} /* of 'standstocks' */
