/***************************************************************************/
/**                                                                       **/
/**             p  h  e  n  o  l  o  g  y  _  g  s  i  .  c               **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Matthias Forkel, mforkel@bgc-jena.mpg.de                          **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-01 09:28:07 +0100 (Wed, 01 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void phenology_gsi(Pft *pft,   /* pointer to PFT variables */
                   Real temp,  /* temperature (deg C) */
                   Real light, /* light, i.e. shortwave-downward radiation (W m-2) */
                   int day     /* day of the year */
                  )
{
  Pfttree *tree;
  tree = pft->data;

  /* get parameters */
  Phen_param tminpar = getpftpar(pft, tmin);
  Phen_param tmaxpar = getpftpar(pft, tmax);
  Phen_param lightpar = getpftpar(pft, light);
  Phen_param wscalpar = getpftpar(pft, wscal);

/*if(light>0){
  printf("%s phen = %.2f temp = %.2f, tmin_sl = %.2f, tmin_base = %.2f, tmin_tau = %.2f\n",pft->par->name, pft->phen, temp, tminpar.sl, tminpar.base, tminpar.tau);
  printf("%s phen = %.2f temp = %.2f, tmax_sl = %.2f, tmax_base = %.2f, tmax_tau = %.2f\n",pft->par->name, pft->phen, temp, tmaxpar.sl, tmaxpar.base, tmaxpar.tau);
  printf("%s phen = %.2f light = %.2f, light_sl = %.2f, light_base = %.2f, light_tau = %.2f\n",pft->par->name, pft->phen, light, lightpar.sl, lightpar.base, lightpar.tau);
}*/

  /* cold temperature response function */
  pft->phen_gsi.tmin += (1 / (1 + exp(-tminpar.sl * (temp - tminpar.base))) - pft->phen_gsi.tmin) * tminpar.tau;

  /* heat stress response function */
  pft->phen_gsi.tmax += (1 / (1 + exp(tmaxpar.sl * (temp - tmaxpar.base))) - pft->phen_gsi.tmax) * tmaxpar.tau;

  /* photosynthetic active radiation response function */
  pft->phen_gsi.light += (1 / (1 + exp(-lightpar.sl * (light - lightpar.base))) - pft->phen_gsi.light) * lightpar.tau;

  /* water availability response function */
  pft->phen_gsi.wscal += (1 / (1 + exp(-wscalpar.sl * (pft->wscal * 100 - wscalpar.base))) - pft->phen_gsi.wscal) * wscalpar.tau;

  /* phenology */
  pft->phen = pft->phen_gsi.tmin * pft->phen_gsi.tmax * pft->phen_gsi.light * pft->phen_gsi.wscal;

  /* aphen for leaf litter turnover */
  /*  switch(getpftpar(pft,phenology))
  {
  case RAINGREEN:
  pft->data->aphen_raingreen += pft->phen;
  break;
  } */
#ifndef YEARLY_TURNOVER
  turnover_daily(&pft->stand->soil.litter, pft, temp);
#endif
  if ((pft->stand->cell->coord.lat >= 0.0 && day == COLDEST_DAY_NHEMISPHERE) ||
    (pft->stand->cell->coord.lat<0.0 && day == COLDEST_DAY_SHEMISPHERE)) {
    pft->aphen = 0.0;
    if (pft->par->type == TREE) tree->isphen = FALSE;
  }
  pft->aphen += pft->phen;

} /* of 'phenology_gsi' */
