/***************************************************************************/
/**                                                                       **/
/**              n  i  t  r  o  g  e  n  _  s  t  r  e  s  s  .  c        **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-23 12:38:53 +0100 (Thu, 23 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Real nitrogen_stress(Soil *soil,       /* Soil variables */
                     Pft *pft,         /* PFT */
                     Real temp,        /* temperature (deg C) */
                     Real daylength,   /* daylength (h) */
                     int npft,         /* number of natural PFTs */
                     int nbiomass,     /* number of biomass types */
                     int ncft          /* number of crop PFTs */
                    )                  /* returns total N demand (gN/m2) */
{
  Real nplant_demand,ndemand_leaf;
  Real ndemand_leaf_opt;
  nplant_demand=0;
  if(pft->bm_inc.carbon>0)
  {
    nplant_demand=ndemand(pft,&ndemand_leaf,pft->vmax,daylength,temp,npft,nbiomass,ncft)*(1+pft->par->knstore);
    ndemand_leaf_opt=ndemand_leaf;
    /* calculation of limitation in ndemad_leaf is missing */
    if(nplant_demand>pft->bm_inc.nitrogen || pft->bm_inc.nitrogen<2)
      pft->stand->cell->output.mn_uptake+=nuptake(soil,pft,&nplant_demand,&ndemand_leaf,npft,nbiomass,ncft)*pft->stand->frac;
    else if(pft->stand->type->landusetype!=AGRICULTURE)
      pft->vscal+=1;
    pft->nleaf=max(pft->nleaf,ndemand_leaf);
    if(ndemand_leaf_opt>ndemand_leaf)
    {
      pft->vmax=vmaxlimit(pft,daylength,temp);
#ifdef DEBUG_N
      printf("vmax_limit=%g  vscal=%g\n\n",pft->vmax,pft->vscal);
#endif
    }
  }
  else if(pft->stand->type->landusetype!=AGRICULTURE)
     pft->vscal+=1;
  return nplant_demand;
} /* of 'nitrogen_stress' */
