/***************************************************************************/
/**                                                                       **/
/**                       n  e  w  p  f  t  .  c                          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function allocates and initializes PFT variables                  **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 07.03.2009                                           **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void newpft(Pft *pft,            /* PFT variables */
            Stand *stand,        /* Stand pointer */
            const Pftpar *pftpar,/* Parameter of PFT */
            int year,            /* anno domini */
            int day              /* day of year (1..365) */
           )
{
  int index;
  pft->par=pftpar;
  /* find litter pool for PFT */
  index=findlitter(&stand->soil.litter,pftpar);
  if(index==NOT_FOUND)
  {
    /* not found, add new litter pool for PFT */
    pft->litter=addlitter(&stand->soil.litter,pftpar)-1;
  }
  else
    /* save index of litter pool */
    pft->litter=index;
  /* Initialize variables to zero */
  pft->stand=stand;
  pft->fpc=pft->nind=pft->wscal=pft->aphen=pft->bm_inc.carbon=pft->wscal_mean=
           pft->gdd=pft->phen=pft->vscal=pft->vmax=pft->nlimit=0.0;
  pft->bm_inc.nitrogen=0;
  pft->phen_gsi.tmin = pft->phen_gsi.tmax = pft->phen_gsi.light = pft->phen_gsi.wscal = 0;
#ifdef DAILY_ESTABLISHMENT
  pft->established=FALSE;
#endif
  pft->par->newpft(pft,year,day); /* type-specific allocation of memory */
} /* of 'newpft' */
