/***************************************************************************/
/**                                                                       **/
/**        i  n  i  t  o  u  t  p  u  t  _  d  a  i  l  y  .  c           **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function initializes monthly output data to zero                  **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2019-06-26 17:39:15 +0200 (Wed, 26 Jun 201#$ **/
/**     By         : $Author:: felutz                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void initoutput_daily(Daily_outputs *output)
{
  output->cleaf=output->cpool=output->croot=output->cso=output->evap=
    output->fphu=output->froot=output->gpp=output->gresp=
    output->growingday=output->hi=output->himind=output->fhiopt=
    output->husum=output->irrig=output->lai=output->laimaxad=
    output->lainppdeficit=output->npp=output->perc=
    output->phen=output->phu=output->prec=output->pvd=output->rd=
    output->rpool=output->rroot=output->rso=output->trans=
    output->vdsum=output->w0=output->w1=output->wdf=output->wevap=
    output->litter_ag=output->litter_agsub=output->litter_cover=
    output->litter_agtemp=output->litter_agmoist=output->litter_agdecomp=
    output->litter_agevap=output->wscal=output->temp=output->sun=output->par=output->pet=
    output->daylength=output->swe=output->discharge=output->runoff=
    output->rh=output->interc=
    output->nuptake=output->n2o_denit=output->n2o_nit=output->n2_denit=
    output->leaching=output->bnf=output->nleaf=output->nroot=output->nso=
    output->npool=output->no3=output->nh4=output->nsoil_slow=
    output->nsoil_fast=output->assim=
    output->nlimit=output->vscal=output->whc=output->wsat=output->ksat= 
    output->fc=output->wp=output->nmin = output->nimmo = output->fw_0 = 
    output->fw_1 = output->fw_evap = 0.0;
} /* of 'initoutput_daily' */
