/***************************************************************************/
/**                                                                       **/
/**                    i  n  i  t  o  u  t  p  u  t  .  c                 **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function allocates output data                                    **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-06-21 10:39:14 +0200 (Tue, 21 Jun 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void initoutput(Output *output, /* Output data */
                int cft,        /* CFT for daily output */
                Bool irrigation,/* irrigation for daily output */
                int npft,       /* number of natural PFTs */
                int nbiomass,   /* number of biomass PFTs */
                int ncft        /* number of crop PFTs */
               )
{
  output->sdate=newvec(int,2*ncft);/* allocate memory for output */
  check(output->sdate);
  output->hdate=newvec(int,2*ncft);
  check(output->hdate);
  output->pft_npp=newvec(Real,(npft-nbiomass)+2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->pft_npp);
  output->pft_nuptake=newvec(Real,(npft-nbiomass)+2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->pft_nuptake);
  output->pft_ndemand=newvec(Real,(npft-nbiomass)+2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->pft_ndemand);
  output->pft_gcgp=newvec(Real,(npft-nbiomass)+2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->pft_gcgp);
  output->gcgp_count=newvec(Real,(npft-nbiomass)+2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->gcgp_count);
  output->pft_harvest=newvec(Harvest,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->pft_harvest);
  output->fpc = newvec(Real, (npft-nbiomass)+1);
  check(output->fpc);
  output->cftfrac=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cftfrac);
  output->cft_consump_water_g=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_consump_water_g);
  output->cft_consump_water_b=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_consump_water_b);
  output->growing_period=newvec(Real,2*(ncft+NGRASS));
  check(output->growing_period);
  output->cft_pet=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_pet);
  output->cft_irrig_events=newvec(int,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_irrig_events);
  output->cft_transp=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_transp);
  output->cft_transp_b=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_transp_b);
  output->cft_evap=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_evap);
  output->cft_evap_b=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_evap_b);
  output->cft_interc=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_interc);
  output->cft_interc_b=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_interc_b);
  output->cft_return_flow_b=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_return_flow_b);
  output->cft_nir=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_nir);
  output->cft_temp=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_temp);
  output->cft_prec=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_prec);
  output->cft_srad=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_srad);
  output->cft_aboveground_biomass=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_aboveground_biomass);
  output->cft_aboveground_nitrogen=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_aboveground_nitrogen);
  output->cft_airrig=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_airrig);
  output->cft_fpar=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_fpar);
  output->cft_luc_image=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_luc_image);
  output->cft_conv_loss_evap=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_conv_loss_evap);
  output->cft_conv_loss_drain=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_conv_loss_drain);
  output->cft_nleaf=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_nleaf);
  output->cft_cleaf=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_cleaf);
  output->cft_nroot=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_nroot);
  output->cft_croot=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_croot);
  output->cft_nveg=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_nveg);
  output->cft_cveg=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_cveg);
  output->cft_nlimit=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_nlimit);
#ifdef DOUBLE_HARVEST
  output->sdate2=newvec(int,2*ncft); /* allocate memory for output */
  check(output->sdate2);
  output->hdate2=newvec(int,2*ncft);
  check(output->hdate2);
  output->syear=newvec(int,2*ncft); /* allocate memory for output */
  check(output->syear);
  output->syear2=newvec(int,2*ncft); /* allocate memory for output */
  check(output->syear2);
  output->pft_harvest2=newvec(Harvest,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->pft_harvest2);
  output->cftfrac2=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cftfrac2);
  output->cft_pet2=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_pet2);
  output->cft_transp2=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_transp2);
  output->cft_evap2=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_evap2);
  output->cft_interc2=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_interc2);
  output->cft_nir2=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_nir2);
  output->cft_airrig2=newvec(Real,2*(ncft+NGRASS+NBIOMASSTYPE));
  check(output->cft_airrig2);
  output->growing_period2=newvec(Real,2*(ncft+NGRASS));
  check(output->growing_period2);
  output->cft_temp2=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_temp2);
  output->cft_prec2=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_prec2);
  output->cft_srad2=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_srad2);
  output->cft_aboveground_biomass2=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_aboveground_biomass2);
  output->cft_aboveground_nitrogen2=newvec(Real,2*(ncft+NGRASS));
  check(output->cft_aboveground_nitrogen2);
#endif  
  initoutput_annual(output, npft, nbiomass,ncft);
  output->daily.cft=cft;
  output->daily.irrigation=irrigation;
} /* of 'initoutput' */
