/***************************************************************************/
/**                                                                       **/
/**                   g  e  t  n  b  i  o  m  a  s  s  .  c               **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function counts number of biomass plantation PFTs                 **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 01.03.2013                                           **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

int getnbiomass(const Pftpar pftpar[], /* PFT parameter array */
                int npft               /* number of natural PFTs */
               )                       /* returns number of biomass PFTs */
{
  int p,nbiomass;
  nbiomass=0;
  for(p=0;p<npft;p++)
    if(pftpar[p].cultivation_type==BIOMASS)
      nbiomass++;
  return nbiomass;
} /* of 'getnbiomass' */
