/***************************************************************************/
/**                                                                       **/
/**               f  s  c  a  n  p  h  e  n  p  a  r  a  m  .  c          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Functions reads phenology parameter from configuration file       **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-01 09:28:07 +0100 (Wed, 01 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Bool fscanphenparam(FILE *file,          /* pointer to text file */
                    Phen_param *phenpar, /* on return phenology params read */
                    Bool isout
                   )                     /* returns TRUE on error */
{
  if(fscanreal(file,&phenpar->sl,"sl param",isout))
    return TRUE;
  if(fscanreal(file,&phenpar->base,"base param",isout))
    return TRUE;
  if(fscanreal(file,&phenpar->tau,"tau param",isout))
    return TRUE;
  return FALSE;
} /* of 'fscanphenparam' */
