/***************************************************************************/
/**                                                                       **/
/**                 f  p  r  i  n  t  s  t  a  n  d  .  c                 **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function prints stand variables in text file                      **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-12-16 15:10:58 +0100 (Fri, 16 Dec 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void fprintstand(FILE *file,           /* Pointer to text file */
                 const Stand *stand,   /* Stand pointer */
                 const Pftpar *pftpar, /* PFT parameter array */
                 int ntotpft           /* total number of PFTs */
                )
{
  int l;
  fprintf(file,"Standfrac:\t%g\n",stand->frac);
  fprintf(file,"Standtype:\t%s\n",stand->type->name);
  fprintf(file,"Standage: \t%d (yr)\n",stand->age);
  /* print stand-specific data */
  stand->type->fprint(file,stand);
  fprintsoil(file,&stand->soil,pftpar,ntotpft);
  fputs("Frac_g:\t\t",file);
  for(l=0;l<NSOILLAYER;l++)
    fprintf(file,"%.2f ",stand->frac_g[l]);
  fputc('\n',file);
  fprintpftlist(file,&stand->pftlist);
} /* of 'fprintstand' */
