/***************************************************************************/
/**                                                                       **/
/**                f  p  r  i  n  t  p  f  t  p  a  r  .  c               **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function prints PFT parameter                                     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-01 09:28:07 +0100 (Wed, 01 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void fprintpftpar(FILE *file, /* pointer to text file */
                  const Pftpar *pftpar /* pointer to PFT parameter */
                 )
{
  int i;
  char *phenology[]={"evergreen","raingreen","summergreen","any","cropgreen"};
  char *cultivation_type[]={"none","biomass","annual crop"};
  char *path[]={"no pathway","C3","C4"};
  fputs("------------------------------------------------------------------------------\n",file);
  fprintf(file,"Id:\t\t%d\n"
               "Name:\t\t%s\n"
               "Cult. type:\t%s\n",pftpar->id,pftpar->name,cultivation_type[pftpar->cultivation_type]);
  fprintf(file,"rootdist:\t");
  for(i=0;i<LASTLAYER;i++)
    fprintf(file,"%g ",pftpar->rootdist[i]);
  fprintf(file,"\nCN:\t\t");
  for(i=0;i<NHSG;i++)
    fprintf(file,"%g ",pftpar->cn[i]);
  fprintf(file,"\n"
               "beta root:\t%g\n"
               "minwscal:\t%g\n"
               "gmin:\t\t%g (mm/s)\n"
               "respcoeff:\t%g\n"
               "nmax:\t\t%g (mg/g)\n"
               "resist:\t\t%g\n"
               "longevity:\t%g (yr)\n"
               "lmro ratio:\t%g\n"
               "ramp:\t\t%g\n"
               "LAI sapl:\t%g\n"
               "gdd5min:\t%g\n"
               "twmax:\t\t%g (deg C)\n"
               "gddbase:\t%g (deg C)\n"
               "min temprange:\t%g\n"
               "emax:\t\t%g (mm/d)\n"
               "intc:\t\t%g\n"
               "alphaa:\t\t%g\n"
               "phenology:\t%s\n"
               "path:\t\t%s\n"
               "tmin_sl:\t%g\n"
               "tmin_base:\t%g\n"
               "tmin_tau:\t%g\n"
               "tmax_sl:\t%g\n"
               "tmax_base:\t%g\n"
               "tmax_tau:\t%g\n"
               "light_sl:\t%g\n"
               "light_base:\t%g\n"
               "light_tau:\t%g\n"
               "wscal_sl:\t%g\n"
               "wscal_base:\t%g\n"
               "wscal_tau:\t%g\n"
               "temp CO2:\t%g %g (deg C)\n"
               "temp photos:\t%g %g (deg C)\n"
               "temp:\t\t%g %g (deg C)\n"
               "min aprec:\t%g (mm)\n"
               "flam:\t\t%g\n"
               "k_litter10:\t%g %g (1/yr)\n"
               "q10_wood:\t%g\n"
               "vmax_up:\t%g (gN/kgC)\n"
               "kNmin:\t\t%g\n"
               "KNmin:\t\t%g\n"
               "CNleaf:\t\t%g %g\n"
               "kNstore:\t%g\n"
               "fN_turnover:\t%g\n"
               "fuel bulk dens.:\t%g (kg/m3)\n"
               "emis. factor:\t%g %g %g %g %g %g\n"
               "wind damp.:\t%g\n"
               "roughness length:\t%g\n",
          pftpar->beta_root,
          pftpar->minwscal,pftpar->gmin,pftpar->respcoeff,pftpar->nmax,
          pftpar->resist,
          pftpar->longevity,pftpar->lmro_ratio,1.0/pftpar->ramp,
          pftpar->lai_sapl,pftpar->gdd5min,
          pftpar->twmax,pftpar->gddbase,pftpar->min_temprange,
          pftpar->emax,pftpar->intc,
          pftpar->alphaa ,phenology[pftpar->phenology],path[pftpar->path],
          pftpar->tmin.sl, pftpar->tmin.base, pftpar->tmin.tau, pftpar->tmax.sl, pftpar->tmax.base, pftpar->tmax.tau, pftpar->light.sl, pftpar->light.base, pftpar->light.tau, pftpar->wscal.sl, pftpar->wscal.base, pftpar->wscal.tau,
          pftpar->temp_co2.low, pftpar->temp_co2.high, pftpar->temp_photos.low,
          pftpar->temp_photos.high, pftpar->temp.low, pftpar->temp.high,
          pftpar->aprec_min,
          pftpar->flam,pftpar->k_litter10.leaf*NDAYYEAR,
          pftpar->k_litter10.wood*NDAYYEAR,
          pftpar->k_litter10.q10_wood,
          pftpar->vmax_up,pftpar->kNmin,pftpar->KNmin,1/pftpar->ncleaf.high,
          1/pftpar->ncleaf.low,pftpar->knstore,pftpar->fn_turnover,
          pftpar->fuelbulkdensity,pftpar->emissionfactor.co2,
          pftpar->emissionfactor.co,pftpar->emissionfactor.ch4,
          pftpar->emissionfactor.voc,pftpar->emissionfactor.tpm,
          pftpar->emissionfactor.nox,pftpar->windspeed,pftpar->roughness);
  pftpar->fprintpar(file,pftpar); /* call type-specific print function */
} /* of 'fprintpftpar' */
