/***************************************************************************/
/**                                                                       **/
/**                 f  p  r  i  n  t  p  f  t  .  c                       **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function prints PFT variables                                     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-06-09 09:18:57 +0200 (Thu, 09 Jun 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

void fprintpft(FILE *file,    /* pointer to text file */
               const Pft *pft /* pointer to PFT variables */
              )
{
  fprintf(file,"PFT:\t\t%s\n",pft->par->name);
  fprintf(file,"fpc:\t\t%g\n",pft->fpc);
  fprintf(file,"nind:\t\t%g (1/m2)\n",pft->nind);
  fprintf(file,"wscal_mean:\t%g\n",pft->wscal_mean);
  fprintf(file,"vscal:\t\t%g\n",pft->vscal);
  fprintf(file,"aphen:\t\t%g\n",pft->aphen);
  fprintf(file,"bminc:\t\t%g (gC/m2) %g (gN/m2)\n",pft->bm_inc.carbon,
          pft->bm_inc.nitrogen);
  fprintf(file,"gdd:\t\t%g\n",pft->gdd); 
  fprintf(file,"FLAImax:\t%g\n",pft->flaimax);
  fprintf(file,"Nleaf:\t\t%g (gN/m2)\n",pft->nleaf);
  /* Print type specific variables */
  pft->par->fprint(file,pft);
} /* of 'fprintpft' */
