/***************************************************************************/
/**                                                                       **/
/**                    f  i  r  e  p  f  t  .  c                          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-03-09 11:38:42 +0100 (Wed, 09 Mar 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

Stocks firepft(Litter *litter,   /* Litter pool */
               Pftlist *pftlist, /* list of established PFTs */
               Real fire_frac    /* fire fraction (0..1) */
              )                  /* returns fire flux (gC/m2, gN/m2) */
{
  int i,p;
  Pft *pft;
  Stocks flux,flux_litter,flux_sum;
  flux_sum.carbon=flux_litter.carbon=flux_sum.nitrogen=flux_litter.nitrogen=0;
  if(isempty(pftlist)) /*if(pftlist->n==0)*/
    return flux_sum;
  foreachpft(pft,p,pftlist)
  {
    flux=fire(pft,&fire_frac);
    flux_sum.carbon+=flux.carbon;
    flux_sum.nitrogen+=flux.nitrogen;
  }
  for(p=0;p<litter->n;p++)
  {
    flux_litter.carbon+=litter->ag[p].trait.leaf.carbon;
    flux_litter.nitrogen+=litter->ag[p].trait.leaf.nitrogen;
    for(i=0;i<NFUELCLASS;i++)
    {
      flux_litter.carbon+=litter->ag[p].trait.wood[i].carbon;
      flux_litter.nitrogen+=litter->ag[p].trait.wood[i].nitrogen;
    }
    litter->ag[p].trait.leaf.carbon*=(1-fire_frac);
    litter->ag[p].trait.leaf.nitrogen*=(1-fire_frac);
    for(i=0;i<NFUELCLASS;i++)
    {
      litter->ag[p].trait.wood[i].carbon*=(1-fire_frac);
      litter->ag[p].trait.wood[i].nitrogen*=(1-fire_frac);
    }
  } /* of 'for(p=0;...)' */
  flux_sum.carbon+=flux_litter.carbon*fire_frac;
  flux_sum.nitrogen+=flux_litter.nitrogen*fire_frac;
  return flux_sum; 
} /* of 'firepft' */
