/***************************************************************************/
/**                                                                       **/
/**                            f  _  l  a  i  .  c                        **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function implements equation C11 in Smith et al. (2014)           **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2018-05-16 15:15:17 +0200 (Wed, 16 May 201#$ **/
/**     By         : $Author:: herzfeld                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"

#define k_l 0.08 /* changed from 0.12 in Smith et al. (2014) */

Real f_lai(Real lai)
{
  if(lai<1.0)
    return max(0.1,lai);
  return exp(k_l*min(lai,7));
} /* of 'f_lai' */
