/***************************************************************************/
/**                                                                       **/
/**                d  a  i  l  y  _  n  a  t  u  r  a  l  .  c            **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function of daily update of natural stand                         **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     See file AUTHORS for list of authors contributing to this code    **/
/**                                                                       **/
/**     Last change: $Date:: 2019-07-10 16:31:39 +0200 (Wed, 10 Jul 201#$ **/
/**     By         : $Author:: felutz                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "natural.h"
#include "agriculture.h"


Real daily_natural(Stand *stand, /* stand pointer */
                   Real co2,     /* atmospheric CO2 (ppmv) */
                   Dailyclimate climate, /* Daily climate values */
                   int day,    /* day (1..365) */
                   Real daylength, /* length of day (h) */
                   const Real gp_pft[], /* pot. canopy conductance for PFTs & CFTs*/
                   Real gtemp_air,  /* value of air temperature response function */
                   Real gtemp_soil, /* value of soil temperature response function */
                   Real gp_stand,
                   Real gp_stand_leafon, /* pot. canopy conduct.at full leaf cover */
                   Real pet,   /* potential evapotranspiration (mm) */
                   Real par,   /* photosynthetic active radiation flux */
                   Real melt,  /* melting water (mm) */
                   int npft,   /* number of natural PFTs */
                   int ncft, /* number of crop PFTs   */
                   int year,
                   Bool withdailyoutput, 
                   Bool UNUSED(intercrop),
                   const Config *config /* LPJ config */
                  ) /* returns runoff (mm) */
{
  int p,l;
  Pft *pft;
  Output *output;
  Real aet_stand[LASTLAYER];
  Real green_transp[LASTLAYER];
  Real evap,evap_blue; /* evaporation (mm) */
  Real *wet; /* wet from pftlist */
  Real rd,gpp,frac_g_evap,runoff,wet_all;
  Real return_flow_b; /* irrigation return flows from surface runoff, lateral runoff and percolation (mm)*/
  Real cover_stand,intercep_stand;
  Real npp; /* net primary productivity (gC/m2) */
  Real wdf; /* water deficit fraction */
  Real gc_pft;
  Real rootdepth=0;
  
#ifdef DAILY_ESTABLISHMENT
  Stocks acflux_estab = {0,0};
#endif
  forrootmoist(l)
    rootdepth+=soildepth[l];
  output=&stand->cell->output;
  evap=evap_blue=cover_stand=intercep_stand=wet_all=0;
  runoff=return_flow_b=0.0;
  stand->growing_days++;

  if (stand->type->landusetype == SETASIDE_RF || stand->type->landusetype == SETASIDE_IR)
  {
  if (param.detail_tillage) { /*in case we have tillage outside of growing season*/
    /*colorado*/
    if (config->with_tillage)
    {
      if (stand->cell->coord.lat<40.76 && stand->cell->coord.lat>40.74) {
        if ((year > 1950  && year < 1999) && day == 300 || day== 30) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 1999 && day == 120 || year == 1999 && day == 130 || year == 1999 && day == 270) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2000 && day == 108 || year == 2000 && day == 118 || year == 2000 && day == 300) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2001 && day == 108 || year == 2001 && day == 120 || year == 2001 && day == 357) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2002 && day == 104 || year == 2002 && day == 114 || year == 2002 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2003 && day == 109 || year == 2003 && day == 119 || year == 2003 && day == 333) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2004 && day == 109 || year == 2004 && day == 119 || year == 2004 && day == 354) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2005 && day == 109 || year == 2005 && day == 119 || year == 2005 && day == 333) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2006 && day == 108 || year == 2006 && day == 118 || year == 2006 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2007 && day == 118 || year == 2007 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2008 && day == 125 || year == 2008 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2009 && day == 120 || year == 2009 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2010 && day == 124 || year == 2010 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
      }
      /*nebraska*/
      if (stand->cell->coord.lat<41.26 && stand->cell->coord.lat>41.24) {
        if (year == 2001 && day == 116 || year == 2001 && day == 149 || year == 2001 && day == 318) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if ((year > 1950 && year<1998) && day == 115) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }

        if (year == 2002 && day == 114 || year == 2002 && day == 163 || year == 2002 && day == 293) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2003 && day == 112 || year == 2003 && day == 168 || year == 2003 && day == 296) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2004 && day == 110 || year == 2004 && day == 159 || year == 2004 && day == 298) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2005 && day == 122 || year == 2005 && day == 167 || year == 2005 && day == 305) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2006 && day == 127 || year == 2006 && day == 163 || year == 2006 && day == 303) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2007 && day == 114 || year == 2007 && day == 157 || year == 2007 && day == 324) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2008 && day == 119 || year == 2008 && day == 171 || year == 2008 && day == 336) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2009 && day == 111 || year == 2009 && day == 335) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2010 && day == 104 || year == 2010 && day == 168 || year == 2010 && day == 314) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        /*2011 has no tillage event*/
        if (year == 2012 && day == 114) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2013 && day == 121) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2014 && day == 114 || 2015 && day == 114) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
      }
      /*michigan*/
      if (stand->cell->coord.lat<42.26 && stand->cell->coord.lat>42.24) {
        if ((year == 1871 || year == 1874 || year == 1877 || year == 1880 || year == 1883 || year == 1886 ||
          year == 1889 || year == 1892 || year == 1895 || year == 1898 || year == 1901 || year == 1904 ||
          year == 1907 || year == 1910 || year == 1913 || year == 1916 || year == 1919 || year == 1922 ||
          year == 1925 || year == 1928 || year == 1931 || year == 1934 || year == 1937 || year == 1940 ||
          year == 1943 || year == 1944 || year == 1946 || year == 1947 || year == 1949 || year == 1950) && day == 105) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }

        if ((year == 1872 || year == 1875 || year == 1878 || year == 1881 || year == 1884 || year == 1887 ||
          year == 1890 || year == 1893 || year == 1896 || year == 1899 || year == 1902 || year == 1905 ||
          year == 1908 || year == 1911 || year == 1914 || year == 1917 || year == 1920 || year == 1923 ||
          year == 1926 || year == 1929 || year == 1932 || year == 1935 || year == 1938 || year == 1941 ||
          year == 1945 || year == 1948 || year == 1951) && day == 75) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        
        if ((year > 1951 && year < 1983) && day == 135) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }

        if (findcft(stand, "maize")) { /*if we have maize*/
          if (year == 1989 && day == 130 || year == 1989 && day == 145 || year == 1989 && day == 182 || year == 1989 && day == 213 || year == 1989 && day == 280) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1991 && day == 145 || year == 1991 && day == 149) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1993 && day == 136 || year == 1993 && day == 139) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          /*no tillage in 1996 and 1999*/
          if (year == 2002 && day == 109 || year == 2002 && day == 128 || year == 2002 && day == 148 || year == 2002 && day == 170) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2005 && day == 115 || year == 2005 && day == 123 || year == 2005 && day == 124) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2008 && day == 126 || year == 2008 && day == 130 || year == 2008 && day == 163) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
        }
        if (!findcft(stand, "maize")) { /*if we have soybean or wheat */
          if (year == 1990 && day == 111 || year == 1990 && day == 124 || year == 1990 && day == 195 || year == 1990 && day == 225) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1992 && day == 115 || year == 1992 && day == 122) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1994 && day == 117 || year == 1994 && day == 139 || year == 1994 && day == 127 || year == 1994 && day == 195 || year == 1994 && day == 225) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1997 && day == 109 || year == 1997 && day == 127 || year == 1997 && day == 135 || year == 1997 && day == 165 || year == 1997 && day == 179) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2000 && day == 123 || year == 2000 && day == 129 || year == 2000 && day == 139 || year == 2000 && day == 181) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2003 && day == 124 || year == 2003 && day == 148 || year == 2003 && day == 283 || year == 2003 && day == 335 || year == 2003 && day == 364) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2006 && day == 121 || year == 2006 && day == 145) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2009 && day == 135 || year == 2009 && day == 140 || year == 2009 && day == 309) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
        }
      }
      /*france*/
      if (stand->cell->coord.lat<48.76 && stand->cell->coord.lat>48.74) {
        if ((year > 1900 && year < 1971) && day == 323) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }

        if ((year == 1971 || year == 1973 || year == 1975 || year == 1977 || year == 1979 || year == 1981 || year == 1983 || year == 1985
          || year == 1987 || year == 1989 || year == 1991 || year == 1993 || year == 1995
          || year == 1997 || year == 1999 || year == 2001 || year == 2003) && day == 301) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if ((year == 1972 || year == 1974 || year == 1976 || year == 1978 || year == 1980 || year == 1982 || year == 1984 || year == 1986
          || year == 1988 || year == 1990 || year == 1992 || year == 1994 || year == 1996
          || year == 1998 || year == 2000 || year == 2002 || year == 2004) && day == 323) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          printf("double check if years are correct\n");
        }
      }
    }
  }/*if detailed tillage*/
  }
  if(getnpft(&stand->pftlist)>0)
  {
    wet=newvec(Real,getnpft(&stand->pftlist)); /* wet from pftlist */
    check(wet);
    for(p=0;p<getnpft(&stand->pftlist);p++)
      wet[p]=0;
  }
  else
    wet=NULL;
  for(l=0;l<LASTLAYER;l++)
    aet_stand[l]=green_transp[l]=0;
  //foreachpft(pft, p, &stand->pftlist)
  if(stand->type->landusetype==SETASIDE_RF || stand->type->landusetype==SETASIDE_IR)
  {
      /* trigger 2nd fertilization */
      //crop = pft->data;

      /*if we do not have detailed fert, do second application, otherwise apply fert on specific days*/
      //#ifndef DETAILED_SIM      
      //#else
      if (param.detail_fert) {
        /*colorado*/
        if (stand->cell->coord.lat<40.76 && stand->cell->coord.lat>40.74) {
          if (year == 2001 && day == 108) {
            stand->soil.NO3[0] += stand->cell->ml.fertilizer_nr[0].crop[2] *0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += stand->cell->ml.fertilizer_nr[0].crop[2] *0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.78* stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", stand->cell->ml.fertilizer_nr[0].crop[2], day, year);
          }
          if (year == 2004 && day == 117) {
            stand->soil.NO3[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.78* stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", stand->cell->ml.fertilizer_nr[0].crop[2], day, year);
          }
          }

        /*nebraska*/
        if (stand->cell->coord.lat<41.26 && stand->cell->coord.lat>41.24) {
    
          if (year == 2002 && day == 109) {
            stand->soil.NO3[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5 /*split application*/;
            stand->soil.NH4[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5 /*split application*/;
            stand->cell->balance.n_influx += stand->cell->ml.fertilizer_nr[0].crop[2] * stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", stand->cell->ml.fertilizer_nr[0].crop[2], day, year);
          }
          if (year == 2003 && day == 113) {
            stand->soil.NO3[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5 /*split application*/;
            stand->soil.NH4[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5 /*split application*/;
            stand->cell->balance.n_influx += stand->cell->ml.fertilizer_nr[0].crop[2] * stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", stand->cell->ml.fertilizer_nr[0].crop[2], day, year);
          }
          if (year == 2004 && day == 111) {
            stand->soil.NO3[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5 /*split application*/;
            stand->soil.NH4[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5 /*split application*/;
            stand->cell->balance.n_influx += stand->cell->ml.fertilizer_nr[0].crop[2] * stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", stand->cell->ml.fertilizer_nr[0].crop[2], day, year);
          }
          if (year == 2006 && day == 124) {
            stand->soil.NO3[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5 /*split application*/;
            stand->soil.NH4[0] += stand->cell->ml.fertilizer_nr[0].crop[2] * 0.5 /*split application*/;
            stand->cell->balance.n_influx += stand->cell->ml.fertilizer_nr[0].crop[2] * stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", stand->cell->ml.fertilizer_nr[0].crop[2], day, year);
          }
        }

        /*michigan, all readin daily_agriculture*/
        /*france, all read in daily_agriculture*/
      }
      //#endif
    }
  /* of foreachpft() */
  foreachpft(pft,p,&stand->pftlist)
  {
    
/* calculate old or new phenology */
    if (config->new_phenology)
      phenology_gsi(pft, climate.temp, climate.swdown, day);
    else
      leaf_phenology(pft, climate.temp, day);
    cover_stand+=pft->fpc*pft->phen;
    intercep_stand+=interception(&wet[p],pft,pet,climate.prec);
    wet_all+=wet[p]*pft->fpc;
  }

  /* soil inflow: infiltration and percolation */
  runoff+=infil_perc_rain(stand,climate.prec+melt-intercep_stand,&return_flow_b,withdailyoutput,config);

  foreachpft(pft,p,&stand->pftlist)
  {
/*
 *  Calculate net assimilation, i.e. gross primary production minus leaf
 *  respiration, including conversion from FPC to grid cell basis.
 *
 */
    gpp=water_stressed(pft,aet_stand,gp_stand,gp_stand_leafon,
                       gp_pft[getpftpar(pft,id)],&gc_pft,&rd,
                       &wet[p],pet,co2,climate.temp,par,daylength,&wdf,npft,ncft,config);
    if(gp_pft[getpftpar(pft,id)]>0.0)
    {
      output->gcgp_count[pft->par->id]++;
      output->pft_gcgp[pft->par->id]+=gc_pft/gp_pft[getpftpar(pft,id)];
    }

    npp=npp(pft,gtemp_air,gtemp_soil,gpp-rd,config->with_nitrogen);
    if (withdailyoutput){
      if (output->daily.cft == ALLNATURAL)
        output->daily.npp+=npp;
    }
    output->dcflux-=npp*stand->frac;
    output->mnpp+=npp*stand->frac;
    output->mgpp+=gpp*stand->frac;
    output->mfpar+=(fpar(pft)*stand->frac*(1.0/(1-stand->cell->lakefrac)))*(1-beta);
    if(config->pft_output_scaled)
      output->pft_npp[pft->par->id]+=npp*stand->frac;
    else
      output->pft_npp[pft->par->id]+=npp;

  } /* of foreachpft */

  /* soil outflow: evap and transpiration */
  waterbalance(stand,aet_stand,green_transp,&evap,&evap_blue,wet_all,pet,cover_stand,
               &frac_g_evap,config->rw_manage);
  if(withdailyoutput)
  {
#ifndef COUPLING_WITH_FMS
    // when coupling with FMS/POEM, we always need evap output,
    // regardless whether it is requested in the LPJ output configuration.
    foreachpft(pft,p,&stand->pftlist)
    if(pft->par->id==output->daily.cft)
#endif
      {
        output->daily.evap=evap;
        forrootsoillayer(l)
          output->daily.trans+=aet_stand[l];
        output->daily.irrig=0;
        output->daily.w0=stand->soil.w[1];
        output->daily.w1=stand->soil.w[2];
        output->daily.wevap=stand->soil.w[0];
        output->daily.par=par;
        output->daily.daylength=daylength;
        output->daily.pet=pet;
//printf("output is written for pft");    
  }
    output->daily.interc=intercep_stand*stand->frac;
  }

  foreachsoillayer(l){
    output->mswc[l]+=(stand->soil.w[l]*stand->soil.whcs[l]+stand->soil.w_fw[l]+stand->soil.wpwps[l]+
                   stand->soil.ice_depth[l]+stand->soil.ice_fw[l])/stand->soil.wsats[l]*stand->frac*(1.0/(1-stand->cell->lakefrac));
    output->daily.nh4+=stand->soil.NH4[l];
    output->daily.no3+=stand->soil.NO3[l];
    output->daily.nsoil_fast+=stand->soil.pool[l].fast.nitrogen;
    output->daily.nsoil_slow+=stand->soil.pool[l].slow.nitrogen;
    /*next lines are added to calculate wfps[frac] instead of soil water [mm] by dividing it by wsat*/
    output->daily.w0 = (stand->soil.w[1] * stand->soil.whcs[1] + stand->soil.w_fw[1] +
      stand->soil.ice_depth[1] + stand->soil.ice_fw[1] + stand->soil.wpwps[1]) / stand->soil.wsats[1];
    output->daily.w1 = (stand->soil.w[2] * stand->soil.whcs[2] + stand->soil.w_fw[2] +
      stand->soil.ice_depth[2] + stand->soil.ice_fw[2] + stand->soil.wpwps[2]) / stand->soil.wsats[2];
    output->daily.wevap = (stand->soil.w[0] * stand->soil.whcs[0] + stand->soil.w_fw[0] +
      stand->soil.ice_depth[0] + stand->soil.ice_fw[0] + stand->soil.wpwps[0]) / stand->soil.wsats[0];
    /*outputs for whc, wsat, fc and wp*/
    output->daily.whc = stand->soil.whc[0] / stand->soil.wsat[0];
    output->daily.wsat = stand->soil.wsat[0];
    output->daily.fc = stand->soil.wfc[0] / stand->soil.wsat[0];
    output->daily.wp = stand->soil.wpwp[0] / stand->soil.wsat[0];

//printf("output is written for soillayer");  
}
  output->daily.litter_cover = stand->soil.litter.agtop_cover;
  for (l = 0; l < stand->soil.litter.n; l++) {
    output->daily.litter_ag += stand->soil.litter.ag[l].trait.leaf.carbon;
    output->daily.litter_agsub += stand->soil.litter.agsub[l].trait.leaf.carbon;
  }
  forrootmoist(l)
    output->mrootmoist+=stand->soil.w[l]*soildepth[l]/rootdepth*stand->frac*(1.0/(1-stand->cell->lakefrac));
  forrootsoillayer(l)
  {
    output->mtransp+=aet_stand[l]*stand->frac;
    output->mtransp_b+=(aet_stand[l]-green_transp[l])*stand->frac;
  }

  output->minterc+=intercep_stand*stand->frac;
  output->mevap+=evap*stand->frac;
  output->mevap_b+=evap_blue*stand->frac;
  output->mreturn_flow_b+=return_flow_b*stand->frac;

  #ifdef DAILY_ESTABLISHMENT
  if (year==911 && day==365) /* TODO: replace the hardcoded value 911 with a more indicative flag like first_year_of_spinup */
     acflux_estab=establishmentpft(stand,config->pftpar,npft,config->ntypes,stand->cell->balance.aprec,year);
  else if (year>911)
	 acflux_estab=establishmentpft(stand,config->pftpar,npft,config->ntypes,stand->cell->balance.aprec,year);
  output->flux_estab.carbon+=acflux_estab.carbon*stand->frac;
  output->flux_estab.nitrogen+=acflux_estab.nitrogen*stand->frac;
  output->dcflux-=acflux_estab.carbon*stand->frac;
#endif

  /* output for green and blue water for evaporation, transpiration and interception */
  /*nooutput_gbw(output,stand,frac_g_evap,frac_g,evap,aet_stand,intercep_stand,npft,ncft,setting);*/
  free(wet);
  return runoff;
} /* of 'daily_natural' */
