/***************************************************************************/
/**                                                                       **/
/**             c  h  e  c  k  _  f  l  u  x  e  s  .  c                  **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function checks for water and carbon balance in a cell            **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 24.02.2009                                           **/
/**     Last change: 19.08.2009 by Christoph Mueller & Elke Stehfest      **/
/**     Last change: $Date:: 2019-06-13 09:43:58 +0200 (Thu, 13 Jun 201#$ **/
/**     By         : $Author:: felutz                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "agriculture.h"

//#define FAIL /* enable abort in case of balance error */

void check_fluxes(Cell *cell,          /* cell pointer */
                  int year,            /* simulation year (AD) */
                  int cellid,          /* cell index */
                  const Config *config /* LPJ configuration */
                 )
{
  Real balanceW,totw;
  Stocks tot={0,0},stocks,delta_tot,balance;
  Stand *stand;
  int s,i;
//#ifdef IMAGE
  int p;
  Pft *pft;
//#endif
  /* carbon balance check */

  foreachstand(stand,s,cell->standlist)
  {
    stocks=standstocks(stand);
    tot.carbon+=stocks.carbon*stand->frac;
    tot.nitrogen+=stocks.nitrogen*stand->frac;
  }
  if(cell->ml.dam)
  {
    tot.carbon+=cell->ml.resdata->pool.carbon;
    tot.nitrogen+=cell->ml.resdata->pool.nitrogen;
  }
  tot.carbon+=cell->balance.estab_storage_grass[0].carbon+cell->balance.estab_storage_tree[0].carbon+cell->balance.estab_storage_grass[1].carbon+
    cell->balance.estab_storage_tree[1].carbon;
  tot.nitrogen+=cell->balance.estab_storage_grass[0].nitrogen+cell->balance.estab_storage_tree[0].nitrogen+cell->balance.estab_storage_grass[1].nitrogen+
    cell->balance.estab_storage_tree[1].nitrogen;
#ifdef IMAGE
  tot.carbon+=cell->ml.image_data->timber.slow+cell->ml.image_data->timber.fast;
#endif
  delta_tot.carbon=tot.carbon-cell->balance.tot.carbon;
  cell->balance.tot.carbon=tot.carbon;
  delta_tot.nitrogen=tot.nitrogen-cell->balance.tot.nitrogen;
  cell->balance.tot.nitrogen=tot.nitrogen;

  balance.carbon=cell->balance.nep-cell->output.firec-cell->output.flux_firewood.carbon+cell->output.flux_estab.carbon-cell->output.flux_harvest.carbon-
    cell->balance.biomass_yield.carbon-delta_tot.carbon-cell->output.negc_fluxes;
  /* for IMAGE but can also be used without IMAGE */
  balance.carbon-=cell->output.deforest_emissions+cell->output.prod_turnover+cell->output.trad_biofuel;

  balance.nitrogen=cell->balance.n_influx-cell->output.firen-cell->balance.n_outflux+cell->output.flux_estab.nitrogen-
    cell->balance.biomass_yield.nitrogen-cell->output.flux_harvest.nitrogen-delta_tot.nitrogen-cell->output.negn_fluxes;
  /*fprintf(stdout,"y: %d c: %d (%0.2f/%0.2f) nep: %.2f firec: %.2f flux_estab: %.2f \n"
		  "         flux_harvest: %.2f totc: %.2f delta_totc %.2f\n biomass_yield: %.2f estab_storage_grass: %.2f estab_storage_tree %.2f\n",
                    year,cellid+config.startgrid,cell->coord.lon,cell->coord.lat,
                    cell->nep,cell->output.firec,
                    cell->output.flux_estab,cell->output.flux_harvest,tot.carbon,delta_totc,cell->biomass_yield,cell->estab_storage_grass[0]+cell->estab_storage_grass[1],cell->estab_storage_tree[0]+cell->estab_storage_tree[1]);
  fflush(stdout);*/
  /*if((year>config->firstyear+1) && fabs(balance.carbon)>0.5)
  {
    printf("y: %d c: %d (%0.2f/%0.2f) BALANCE_C %.10f nep: %.2f firec: %.2f flux_estab: %.2f flux_harvest: %.2f \n"
    		"delta_totc: %.2f totc %.2f biomass_yield %.2f \n",
         year,cellid+config->startgrid,cell->coord.lon,cell->coord.lat,balance.carbon,cell->balance.nep,cell->output.firec,cell->output.flux_estab.carbon,
         cell->output.flux_harvest.carbon,delta_tot.carbon,tot.carbon,cell->balance.biomass_yield.carbon);
    printf("estab_storage_tree %g %g  \n", cell->balance.estab_storage_tree[0].carbon,cell->balance.estab_storage_tree[1].carbon);
    printf("estab_storage_grass %g %g \n", cell->balance.estab_storage_grass[0].carbon,cell->balance.estab_storage_grass[1].carbon);
    fflush(stdout);
    foreachstand(stand,s,cell->standlist)
    {
      printf("C-balance on stand %d LUT %s, standfrac %g litter %g \n",
        s,stand->type->name,stand->frac,littercarbon(&stand->soil.litter));
      fflush(stdout);
      foreachpft(pft,p,&stand->pftlist)
        printf("pft %d, %s, vegc %g bm_inc %g fpc %g\n",
               p,pft->par->name,vegc_sum(pft),pft->bm_inc.carbon,pft->fpc);
      fflush(stdout);
    }
  } */

  if(year>config->firstyear+1 && fabs(balance.carbon)>1)
  {
#ifdef IMAGE
    foreachstand(stand,s,cell->standlist)
    {
      printf("C-balance on stand %d LUT %s, standfrac %g litter %g timber_frac %g\n",
        s,stand->type->name,stand->frac,littercarbon(&stand->soil.litter),cell->ml.image_data->timber_frac);
      fflush(stdout);
      foreachpft(pft,p,&stand->pftlist)
        printf("pft %d, %s, vegc %g\n",
               p,pft->par->name,vegc_sum(pft));
      fflush(stdout);
    } /* of 'foreachstand' */
    fail(INVALID_CARBON_BALANCE_ERR,TRUE,"y: %d c: %d (%0.2f/%0.2f) BALANCE_C-error %.10f nep: %.2f firec: %.2f flux_estab: %.2f flux_harvest: %.2f delta_totc: %.2f\ndeforest_emissions: %.2f product_turnover: %.2f trad_biofuel: %.2f product pools %.2f %.2f timber_harvest %.2f ftimber %.2f fburn %.2f\n",
         year,cellid+config->startgrid,cell->coord.lon,cell->coord.lat,balanceC,cell->balance.nep,
         cell->output.firec,
         cell->output.flux_estab,cell->output.flux_harvest,delta_tot.carbon,
         cell->output.deforest_emissions,cell->output.prod_turnover,cell->output.trad_biofuel,
         cell->ml.image_data->timber.slow,cell->ml.image_data->timber.fast,cell->output.timber_harvest,
         cell->ml.image_data->timber_f,cell->ml.image_data->fburnt);
#else
#ifdef FAIL
    fail(INVALID_CARBON_BALANCE_ERR,TRUE,
#else
    fprintf(stderr,"ERROR004: "
#endif
    	 "y: %d c: %d (%0.2f/%0.2f) BALANCE_C-error %.10f nep: %.2f\n"
                "                            firec: %.2f flux_estab: %.2f \n"
                "                            flux_harvest: %.2f delta_tot.carbon: %.2f biomass_yield: %.2f\n"
                "                            estab_storage_grass: %.2f %.2f estab_storage_tree %.2f %.2f\n"
                "                            deforest_emissions: %.2f product_turnover: %.2f,lakefrac=%g\n"
#ifndef FAIL
     ".\n"
#endif
         ,year,cellid+config->startgrid,cell->coord.lon,cell->coord.lat,balance.carbon,cell->balance.nep,cell->output.firec,
         cell->output.flux_estab.carbon,cell->output.flux_harvest.carbon,delta_tot.carbon,cell->balance.biomass_yield.carbon,
         cell->balance.estab_storage_grass[0].carbon,cell->balance.estab_storage_grass[1].carbon,cell->balance.estab_storage_tree[0].carbon,cell->balance.estab_storage_tree[1].carbon,
         cell->output.deforest_emissions,cell->output.prod_turnover,cell->lakefrac);
#endif
  }
  if(config->with_nitrogen && year>config->firstyear+1 && fabs(balance.nitrogen)>.2)
  {
#ifdef FAIL
    fail(INVALID_NITROGEN_BALANCE_ERR,TRUE,
#else
    fprintf(stderr,"ERROR032: "
#endif
"N-balance on y %d c %d (%0.2f/%0.2f) BALANCE_N-error %.10f n_influx %g n_outflux %g n_harvest %g n_biomass_yield %g n_estab %g delta_tot=%g total nitrogen=%g estab_storage grass [0] = %g estab_storage grass [1] = %g  estab_storage tree [0] = %g estab_storage tree [1] = %g \n"
#ifndef FAIL
     ".\n"
#endif
      ,year,cellid+config->startgrid,cell->coord.lon,cell->coord.lat,balance.nitrogen,
      cell->balance.n_influx,cell->balance.n_outflux,cell->output.flux_harvest.nitrogen,cell->balance.biomass_yield.nitrogen,cell->output.flux_estab.nitrogen,delta_tot.nitrogen,tot.nitrogen,
      cell->balance.estab_storage_grass[0].nitrogen,cell->balance.estab_storage_grass[1].nitrogen,cell->balance.estab_storage_tree[0].nitrogen,
          cell->balance.estab_storage_tree[1].nitrogen);
fprintf(stderr,"fertilizer input %g\n",cell->ml.fertilizer_nr[0].crop[2]);
fflush(stderr);
    foreachstand(stand,s,cell->standlist){
      foreachpft(pft,p,&stand->pftlist){
        fprintf(stderr,"PFT bm_inc nitrogen %g\n",pft->bm_inc.nitrogen);
      }
    }
  }
  /* water balance check */
  totw=(cell->discharge.dmass_lake+cell->discharge.dmass_river)/cell->coord.area;
  foreachstand(stand,s,cell->standlist)
  {
    totw+=soilwater(&stand->soil)*stand->frac;
/*    if(&stand->type->name!=NATURAL)
    {
      data=&stand->data;
      totw+=(data->irrig_stor+data->irrig_amount)*stand->frac;
    }*/
  }
  if(cell->ml.dam)
  {
     totw+=cell->ml.resdata->dmass/cell->coord.area;/*+cell->resdata->dfout_irrigation/cell->coord.area; */
     for(i=0;i<NIRRIGDAYS;i++)
       totw+=cell->ml.resdata->dfout_irrigation_daily[i]/cell->coord.area;
  }
  balanceW=totw-cell->balance.totw-cell->balance.aprec+cell->balance.awater_flux;
  if(year>config->firstyear+1 && fabs(balanceW)>1.5)
    /*fail(INVALID_WATER_BALANCE_ERR,TRUE,"y: %d c: %d (%0.2f/%0.2f) BALANCE_W-error %.2f cell->totw:%.2f totw:%.2f awater_flux:%.2f aprec:%.2f\n",*/
     printf("y: %d c: %d (%0.2f/%0.2f) BALANCE_W-error %.2f cell->totw:%.2f totw:%.2f awater_flux:%.2f aprec:%.2f\n",
         year,cellid+config->startgrid,cell->coord.lon,cell->coord.lat,balanceW,cell->balance.totw,totw,
         cell->balance.awater_flux,cell->balance.aprec);
  cell->balance.totw=totw;
} /* of 'check_fluxes' */
