/***************************************************************************/
/**                                                                       **/
/**                   s  o  w  i  n  g  .  c                              **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 25.01.2006  by S.Jachner, M.Gumpenberger             **/
/**     Last change: $Date:: 2019-06-13 09:43:58 +0200 (Thu, 13 Jun 201#$ **/
/**     By         : $Author:: felutz                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "crop.h"
#include "agriculture.h"

Stocks sowing_season(Cell *cell,            /* pointer to cell */
                   int day,               /* day (1..365) */
                   int npft,              /* number of natural PFTs  */
                   int ncft,              /* number of crop PFTs */
                   Real dprec,            /* today's precipitation (mm) */
                   const Config *config,  /* LPJ settings */
                   int year
                  )                       /* returns establish flux (gC/m2) */
{
  Bool alloc_today_rf=FALSE, alloc_today_ir=FALSE,istimber;
  int cft,m,mm,dayofmonth,month,s,s2;
  Stocks flux_estab={0,0};
  Stocks flux_return={0,0};
  const Pftcroppar *croppar;
  Stand *setasidestand;

#ifdef IMAGE
  istimber=(config->start_imagecoupling!=INT_MAX);
#else
  istimber=FALSE;
#endif
  s=findlandusetype(cell->standlist,SETASIDE_RF);
  s2=findlandusetype(cell->standlist,SETASIDE_IR);
  if(s!=NOT_FOUND || s2!=NOT_FOUND)
  {
//printf("setaside not found in year %d \n",year);
    for(cft=0;cft<ncft;cft++)
    {
      croppar=config->pftpar[npft+cft].data;
      cvrtdaymonth(&dayofmonth,&month,day);

      if (cell->ml.seasonality_type==NO_SEASONALITY) /*no seasonality*/
      {
        if (month==cell->ml.sowing_month[cft] && dayofmonth==1)
        {
          /*rainfed CFTs*/
          s=findlandusetype(cell->standlist,SETASIDE_RF);

          if(s!=NOT_FOUND)
          {
            setasidestand=getstand(cell->standlist,s);
            if(cell->ml.cropdates[cft].fallow<=0 &&
              check_lu(cell->standlist,cell->ml.landfrac[0].crop[cft],npft+cft,FALSE))
            {
              if(!alloc_today_rf)
              {
                allocation_today(setasidestand, config->ntypes);
                alloc_today_rf=TRUE;
              }
              flux_return=cultivate(cell,config->pftpar+npft+cft,
                cell->ml.cropdates[cft].vern_date20,
                cell->ml.landfrac[0].crop[cft],FALSE,day,FALSE,
                setasidestand,istimber,config->with_tillage,config->irrig_scenario,npft,ncft,cft,year);
              /* crops get 2.0 g/m2 of N */
              flux_estab.carbon+=flux_return.carbon;
              flux_estab.nitrogen+=flux_return.nitrogen;
//printf("maize 1 \n");

#ifndef DOUBLE_HARVEST
                cell->output.sdate[cft]=day;

#endif
              if(config->sdate_option==FIXED_SDATE)
                cell->ml.sdate_fixed[cft]=day;
              /*if(setasidestand->type->landusetype!=SETASIDE)
                break;*/
            }
          } /*of rainfed CFTs*/
          /*irrigated CFTs*/
          s=findlandusetype(cell->standlist,SETASIDE_IR);

          if(s!=NOT_FOUND)
          {
            setasidestand=getstand(cell->standlist,s);if(cell->ml.cropdates[cft].fallow_irrig<=0 &&
              check_lu(cell->standlist,cell->ml.landfrac[1].crop[cft],npft+cft,TRUE))
            {
              if(!alloc_today_ir)
              {
                allocation_today(setasidestand,config->ntypes);
                alloc_today_ir=TRUE;
              }
              flux_return=cultivate(cell,config->pftpar+npft+cft,
                cell->ml.cropdates[cft].vern_date20,
                cell->ml.landfrac[1].crop[cft],TRUE,day,FALSE,
                setasidestand,istimber,config->with_tillage,config->irrig_scenario,npft,ncft,cft,year);
              /* crops get 2.0 g/m2 of N */
              flux_estab.carbon+=flux_return.carbon;
              flux_estab.nitrogen+=flux_return.nitrogen;
#ifndef DOUBLE_HARVEST
              cell->output.sdate[cft+ncft]=day;
//printf("maize 1 \n");
#endif
              if(config->sdate_option==FIXED_SDATE)
                cell->ml.sdate_fixed[cft+ncft]=day;
              /*if(setasidestand->type->landusetype!=SETASIDE)
                break;*/
            }
          } /*of irrigated CFTs*/
        }
      } /*of no seasonality*/

      if (cell->ml.seasonality_type==PREC || cell->ml.seasonality_type==PRECTEMP) /*precipitation-dependent rules*/
      {
        s=findlandusetype(cell->standlist,SETASIDE_RF);

        if(s!=NOT_FOUND)
        {
          setasidestand=getstand(cell->standlist,s);
          if (month==cell->ml.sowing_month[cft] && (dprec > MIN_PREC || dayofmonth==ndaymonth[month-1])) /*no irrigation, first wet day*/
          {
            if(cell->ml.cropdates[cft].fallow<=0 &&
              check_lu(cell->standlist,cell->ml.landfrac[0].crop[cft],npft+cft,FALSE))
            {
              if(!alloc_today_rf)
              {
                allocation_today(setasidestand,config->ntypes);
                alloc_today_rf=TRUE;
              }
              flux_return=cultivate(cell,config->pftpar+npft+cft,
                cell->ml.cropdates[cft].vern_date20,
                cell->ml.landfrac[0].crop[cft],FALSE,day,FALSE,
                setasidestand,istimber,config->with_tillage,config->irrig_scenario,npft,ncft,cft,year);
              /* crops get 2.0 g/m2 of N */
              flux_estab.carbon+=flux_return.carbon;
              flux_estab.nitrogen+=flux_return.nitrogen;
//printf("maize 2 \n");

#ifndef DOUBLE_HARVEST
              cell->output.sdate[cft]=day;
#endif
              if(config->sdate_option==FIXED_SDATE)
                cell->ml.sdate_fixed[cft]=day;
              /*if(setasidestand->type->landusetype!=SETASIDE)
                break;*/
            }
          }
        }
        s=findlandusetype(cell->standlist,SETASIDE_IR);

        if(s!=NOT_FOUND)
        {
          setasidestand=getstand(cell->standlist,s);
          if (month==cell->ml.sowing_month[cft+ncft] && (dprec > MIN_PREC || dayofmonth==ndaymonth[month-1])) /*irrigation, first wet day*/ 
          {
            if(cell->ml.cropdates[cft].fallow_irrig<=0 &&
              check_lu(cell->standlist,cell->ml.landfrac[1].crop[cft],npft+cft,TRUE))
            {
              if(!alloc_today_ir)
              {
                allocation_today(setasidestand,config->ntypes);
                alloc_today_ir=TRUE;
              }
              flux_return=cultivate(cell,config->pftpar+npft+cft,
                cell->ml.cropdates[cft].vern_date20,
                cell->ml.landfrac[1].crop[cft],TRUE,day,FALSE,
                setasidestand,istimber,config->with_tillage,config->irrig_scenario,npft,ncft,cft,year);
              /* crops get 2.0 g/m2 of N */
              flux_estab.carbon+=flux_return.carbon;
              flux_estab.nitrogen+=flux_return.nitrogen;
#ifndef DOUBLE_HARVEST
              cell->output.sdate[cft+ncft]=day;
//printf("maize 2 \n");
#endif
              if(config->sdate_option==FIXED_SDATE)
                cell->ml.sdate_fixed[cft+ncft]=day;
              /*if(setasidestand->type->landusetype!=SETASIDE)
                break;*/
            }
          }
        }
      } /*of precipitation seasonality*/

      if (cell->ml.seasonality_type==TEMP || cell->ml.seasonality_type==TEMPPREC) /*temperature-dependent rule*/
      {
        s=findlandusetype(cell->standlist,SETASIDE_RF);

        if(s!=NOT_FOUND)
        {
          setasidestand=getstand(cell->standlist,s);
          if (month==cell->ml.sowing_month[cft]) /*no irrigation*/
          {
            m = month-1; /*m runs from 0 to 11*/
            mm = (m-1 < 0) ? NMONTH-1 : m-1; /*mm is the month before*/
            if (cell->climbuf.mtemp20[mm] > cell->climbuf.mtemp20[m] && croppar->calcmethod_sdate==TEMP_WTYP_CALC_SDATE)
            {
              /*calculate day when temperature exceeds or falls below a crop-specific temperature threshold - from former function calc_cropdates*/
              if(((cell->climbuf.temp[NDAYS-1]<croppar->temp_fall)
                &&(cell->climbuf.temp[NDAYS-2]>=croppar->temp_fall || dayofmonth==1)) || dayofmonth==ndaymonth[m]) /*sow winter variety*/
              {
                if(cell->ml.cropdates[cft].fallow<=0 &&
                  check_lu(cell->standlist,cell->ml.landfrac[0].crop[cft],npft+cft,FALSE))
                {
                  if(!alloc_today_rf)
                  {
                    allocation_today(setasidestand, config->ntypes);
                    alloc_today_rf=TRUE;
                  }
                  flux_return=cultivate(cell,config->pftpar+npft+cft,
                    cell->ml.cropdates[cft].vern_date20,
                    cell->ml.landfrac[0].crop[cft],FALSE,day,TRUE,
                    setasidestand,istimber,config->with_tillage,config->irrig_scenario,npft,ncft,cft,year);
                  flux_estab.carbon+=flux_return.carbon;
                  flux_estab.nitrogen+=flux_return.nitrogen;
#ifndef DOUBLE_HARVEST
                  cell->output.sdate[cft]=day;
#endif
                  if(config->sdate_option==FIXED_SDATE)
                    cell->ml.sdate_fixed[cft]=day;
                  /*if(setasidestand->type->landusetype!=SETASIDE)
                    break;*/
                }
              }
            }
            else if (((cell->climbuf.temp[NDAYS-1]>croppar->temp_spring)
              &&(cell->climbuf.temp[NDAYS-2]<=croppar->temp_spring || dayofmonth==1)) || dayofmonth==ndaymonth[m]) /*sow summer variety */
            {
              if(cell->ml.cropdates[cft].fallow<=0 &&
                check_lu(cell->standlist,cell->ml.landfrac[0].crop[cft],npft+cft,FALSE))
              {
                if(!alloc_today_rf)
                {
                  allocation_today(setasidestand, config->ntypes);
                  alloc_today_rf=TRUE;
                }
                /*problem: in year where we dont have a crop growing, we still assign 1000 to landuse band*/
                /*in those years, we assing 1000 to the sowing day (never reached), in the runs where the sowing*/
                /*file is not read, the sowing date is calulated, which should be avoided, the opposite is true for below*/
                /*france*/
                /*if (cell->coord.lat<48.76 && cell->coord.lat>48.74) {
                  if (param.detail_phu == 0) {
                    if (year == 1971 || year == 1973 || year == 1975 || year == 1977 || year == 1979 || year == 1981 || year == 1983 || year == 1985
                      || year == 1987 || year == 1989 || year == 1991 || year == 1993 || year == 1995
                      || year == 1997 || year == 1999 || year == 2001 || year == 2003) {*/
                flux_return=cultivate(cell,config->pftpar+npft+cft,
                  cell->ml.cropdates[cft].vern_date20,
                  cell->ml.landfrac[0].crop[cft],FALSE,day,FALSE,
                  setasidestand,istimber,config->with_tillage,config->irrig_scenario,npft,ncft,cft,year);
                flux_estab.carbon+=flux_return.carbon;
                flux_estab.nitrogen+=flux_return.nitrogen;
printf("non irrigated maize is sown on day %d and year %d \n", day, year);
                   /* }
                  }
               }*/
#ifndef DOUBLE_HARVEST

               /* if (cell->coord.lat<48.76 && cell->coord.lat>48.74) {
                  if (param.detail_phu == 0) {
                    if (year == 1971 || year == 1973 || year == 1975 || year == 1977 || year == 1979 || year == 1981 || year == 1983 || year == 1985
                      || year == 1987 || year == 1989 || year == 1991 || year == 1993 || year == 1995
                      || year == 1997 || year == 1999 || year == 2001 || year == 2003) {
*/
                cell->output.sdate[cft]=day;
/*                     }
                  }
                 }*/
#endif
                if(config->sdate_option==FIXED_SDATE)
                  cell->ml.sdate_fixed[cft]=day;
                /*if(setasidestand->type->landusetype!=SETASIDE)
                  break;*/
              }
            } /*of cultivating summer variety*/
          } /*of if month==ml.sowing_month[cft]*/
        }
        s=findlandusetype(cell->standlist,SETASIDE_IR);

        if(s!=NOT_FOUND)
        {
          setasidestand=getstand(cell->standlist,s);

          if (month==cell->ml.sowing_month[cft+ncft]) /*irrigation*/
          {
            m = month-1; /*m runs from 0 to 11*/
            mm = (m-1 < 0) ? NMONTH-1 : m-1; /*mm is the month before*/
            if (cell->climbuf.mtemp20[mm] > cell->climbuf.mtemp20[m] && croppar->calcmethod_sdate==TEMP_WTYP_CALC_SDATE)
            {
              /*calculate day when temperature exceeds or falls below a crop-specific temperature threshold - from former function calc_cropdates*/
              if(((cell->climbuf.temp[NDAYS-1]<croppar->temp_fall)
                &&(cell->climbuf.temp[NDAYS-2]>=croppar->temp_fall || dayofmonth==1)) || dayofmonth==ndaymonth[m]) /*sow winter variety*/
              {
                if(cell->ml.cropdates[cft].fallow_irrig<=0 &&
                  check_lu(cell->standlist,cell->ml.landfrac[1].crop[cft],npft+cft,TRUE))
                {
                  if(!alloc_today_ir)
                  {
                    allocation_today(setasidestand, config->ntypes);
                    alloc_today_ir=TRUE;
                  }
                  flux_return=cultivate(cell,config->pftpar+npft+cft,
                    cell->ml.cropdates[cft].vern_date20,
                    cell->ml.landfrac[1].crop[cft],TRUE,day,TRUE,
                    setasidestand,istimber,config->with_tillage,config->irrig_scenario,npft,ncft,cft,year);
                  flux_estab.carbon+=flux_return.carbon;
                  flux_estab.nitrogen+=flux_return.nitrogen;
#ifndef DOUBLE_HARVEST
                  cell->output.sdate[cft+ncft]=day;
                  //cell->output.sdate[cft+ncft]=278;
printf("sdate is on day %d \n",cell->output.sdate[cft+ncft]);
#endif
                  if(config->sdate_option==FIXED_SDATE)
                    cell->ml.sdate_fixed[cft+ncft]=day;
                  /*if(setasidestand->type->landusetype!=SETASIDE)
                    break;*/
                }
              }
            }
            else if (((cell->climbuf.temp[NDAYS-1]>croppar->temp_spring)
              &&(cell->climbuf.temp[NDAYS-2]<=croppar->temp_spring || dayofmonth==1)) || dayofmonth==ndaymonth[m]) /*sow summer variety */
            {
              if(cell->ml.cropdates[cft].fallow_irrig<=0 &&
                check_lu(cell->standlist,cell->ml.landfrac[1].crop[cft],npft+cft,TRUE))
              {
                if(!alloc_today_ir)
                {
                  allocation_today(setasidestand, config->ntypes);
                  alloc_today_ir=TRUE;
                }
                /*problem: in year where we dont have a crop growing, we still assign 1000 to landuse band*/
                /*in those years, we assing 1000 to the sowing day (never reached), in the runs where the sowing*/
                /*file is not read, the sowing date is calulated, which should be avoided. the opposite is true below*/
                /*france*/
                //if (cell->coord.lat<48.76 && cell->coord.lat>48.74) {
                 // if (param.detail_phu == 0) {
                    /*if maize should be grown, read cultivate, else not*/
                   // if (year == 1971 || year == 1973 || year == 1975 || year == 1977 || year == 1979 || year == 1981 || year == 1983 || year == 1985
                     // || year == 1987 || year == 1989 || year == 1991 || year == 1993 || year == 1995
                      //|| year == 1997 || year == 1999 || year == 2001 || year == 2003) {
                      flux_return = cultivate(cell, config->pftpar + npft + cft,
                        cell->ml.cropdates[cft].vern_date20,
                        cell->ml.landfrac[1].crop[cft], TRUE, day, FALSE,
                        setasidestand, istimber, config->with_tillage, config->irrig_scenario, npft, ncft, cft, year); /*TRUE:irrigated FALSE:wintertype*/
                      flux_estab.carbon += flux_return.carbon;
                      flux_estab.nitrogen += flux_return.nitrogen;
                      printf("irrigated maize is sown on day %d and year %d \n", day, year);
                   // }
                 // }
               // }
  //            if(!cell->coord.lat<48.76 && !cell->coord.lat>48.74){
//} 
#ifndef DOUBLE_HARVEST
//                if (cell->coord.lat<48.76 && cell->coord.lat>48.74) {
//                  if (param.detail_phu == 0) {
                    /*if maize should be grown, read cultivate, else not*/
//                    if (year == 1971 || year == 1973 || year == 1975 || year == 1977 || year == 1979 || year == 1981 || year == 1983 || year == 1985
//                      || year == 1987 || year == 1989 || year == 1991 || year == 1993 || year == 1995
//                      || year == 1997 || year == 1999 || year == 2001 || year == 2003) {

                cell->output.sdate[cft+ncft]=day;
//
//                   }
//                 }
//               } 
//                if (!cell->coord.lat<48.76 && cell->coord.lat>48.74) {
//                  cell->output.sdate[cft+ncft]=day;
//                   }

#endif
                if(config->sdate_option==FIXED_SDATE)
                  cell->ml.sdate_fixed[cft+ncft]=day;
                /*if(setasidestand->type->landusetype!=SETASIDE)
                  break;*/
              }
            } /*of cultivating summer variety*/
          } /*of if month==ml.sowing_month[cft+ncft]*/
        }
      } /*of temperature seasonality or both seasonality*/
    }  /*for(cft=...) */
  }
  return flux_estab;
} /* of 'sowing_season' */
/*
for each cell and day, called in update_daily:
{
  month=monthofday;

  for(cft=0;cft<ncft;cft++)
  {
    if (seasonality_type[cell]==no seasonality)
    {
      if (month=sowing month[cft] && dayofmonth==1)
      {
        cultivate(irrigation=FALSE,wtype=FALSE)
          output->sdate[cft]=day
          cultivate(irrigation=TRUE, wtype=FALSE)
          output->sdate[cft+ncft]=day
      }
    }
    if (seasonality_type[cell]==precipitation)
    {
      if ((month==ml.sowing_month[cft] && precipitation > MIN_PREC) || dayofmonth==31)
      {
        cultivate(irrigation=FALSE, wtype=FALSE)
          output->sdate[cft]=day
      }
      if (month==ml.sowing_month[cft+ncft])
      {
        cultivate(irrigation=TRUE, wtype=FALSE)
          output->sdate[cft+ncft]=day
      }
    }
    if (seasonality_type[cell]==temperature or both)
    {
      if (month==ml.sowing_month[cft])
      {
        if (climbuf->mtemp20[lastmonth]>climbuf->mtemp20[thismonth] && calc_method = TEMP_WTYP_CALC_SDATE) => we are in fall
        {
          if(((cell->climbuf.temp[NDAYS-1]<croppar->temp_fall)
            && (cell->climbuf.temp[NDAYS-2]>=croppar->temp_fall || day==firstdayofmonth)) || day==lastdayofmonth)
            cultivate(irrigation=FALSE, wtype=TRUE)
            output->sdate[cft]=day
          else if (((cell->climbuf.temp[NDAYS-1]>croppar->temp_spring)
          && (cell->climbuf.temp[NDAYS-2]<=croppar->temp_spring || dayofmonth==1)) || dayofmonth==ndaymonth[m])
          cultivate(irrigation=FALSE, wtype=FALSE)
          output->sdate[cft]=day
        }
      }

      if (month==cell->ml.sowing_month[cft+ncft])
      {
        if (climbuf->mtemp20[lastmonth]>climbuf->mtemp20[thismonth] && calc_method = TEMP_WTYP_CALC_SDATE) => we are in fall
        {
          if(((cell->climbuf.temp[NDAYS-1]<croppar->temp_fall)
            && (cell->climbuf.temp[NDAYS-2]>=croppar->temp_fall || day==firstdayofmonth)) || day==lastdayofmonth)
            cultivate(irrigation=TRUE, wtype=TRUE)
            output->sdate[cft]=day
          else if (((cell->climbuf.temp[NDAYS-1]>croppar->temp_spring) => we are in spring
          && (cell->climbuf.temp[NDAYS-2]<=croppar->temp_spring || dayofmonth==1)) || dayofmonth==ndaymonth[m])
          cultivate(irrigation=TRUE, wtype=FALSE)
          output->sdate[cft]=day
        }
      }
    }
  }
*/
