/***************************************************************************/
/**                                                                       **/
/**                   s  o  w  i  n  g  .  c                              **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-10-26 14:35:15 +0200 (Thu, 26 Oct 201#$ **/
/**     By         : $Author:: herzfeld                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "crop.h"
#include "agriculture.h"

Stocks sowing_prescribe(Cell *cell,
                      int day,
                      int npft,
                      int ncft,
                      const Config *config,
                      int year
                     )
{
  Stocks flux_estab={0,0};
  Stocks flux_return={0,0};
  Stand *setasidestand;
  Bool alloc_today_rf=FALSE, alloc_today_ir=FALSE,istimber;
  const Pftcroppar *croppar;
  int cft,s,s2;
  int earliest_sdate;
  Bool wtype=FALSE;

#ifdef IMAGE
  istimber=(config->start_imagecoupling!=INT_MAX);
#else
  istimber=FALSE;
#endif
  s=findlandusetype(cell->standlist,SETASIDE_RF);
  s2=findlandusetype(cell->standlist,SETASIDE_IR);
  if(s!=NOT_FOUND || s2!=NOT_FOUND)
  {

    for(cft=0;cft<ncft;cft++)
    {
      croppar=config->pftpar[npft+cft].data;
      earliest_sdate=(cell->coord.lat>=0) ? croppar->initdate.sdatenh : croppar->initdate.sdatesh;

      /*rainfed crops*/
      s=findlandusetype(cell->standlist,SETASIDE_RF);
      if(s!=NOT_FOUND)
      {
        setasidestand=getstand(cell->standlist,s);

        if(day==cell->ml.sdate_fixed[cft])
        {
          wtype = (croppar->calcmethod_sdate==TEMP_WTYP_CALC_SDATE && day>earliest_sdate) ? TRUE : FALSE;
          if(check_lu(cell->standlist,cell->ml.landfrac[0].crop[cft],npft+cft,FALSE))
          {
            if(!alloc_today_rf)
            {
              allocation_today(setasidestand, config->ntypes);
              alloc_today_rf=TRUE;
            }
            flux_return=cultivate(cell,config->pftpar+npft+cft,
              cell->ml.cropdates[cft].vern_date20,
              cell->ml.landfrac[0].crop[cft],FALSE,day,wtype,
              setasidestand,istimber,config->with_tillage,config->irrig_scenario,npft,ncft,cft,year);
            flux_estab.carbon+=flux_return.carbon;
            flux_estab.nitrogen+=flux_return.nitrogen;
#ifndef DOUBLE_HARVEST
            cell->output.sdate[cft]=day;
#endif
            /*if(setasidestand->type->landusetype!=SETASIDE)
              break;*/
          }
        }/*of rainfed CFTs*/
      }
      s=findlandusetype(cell->standlist,SETASIDE_IR);
      if(s!=NOT_FOUND)
      {
        setasidestand=getstand(cell->standlist,s);


        /*irrigated crops*/
        if(day==cell->ml.sdate_fixed[cft+ncft])
        {
          wtype = (croppar->calcmethod_sdate==TEMP_WTYP_CALC_SDATE && day>earliest_sdate) ? TRUE : FALSE;
          if(check_lu(cell->standlist,cell->ml.landfrac[1].crop[cft],npft+cft,TRUE))
          {
            if(!alloc_today_ir)
            {
              allocation_today(setasidestand, config->ntypes);
              alloc_today_ir=TRUE;
            }
            flux_return=cultivate(cell,config->pftpar+npft+cft,
              cell->ml.cropdates[cft].vern_date20,
              cell->ml.landfrac[1].crop[cft],TRUE,day,wtype,
              setasidestand,istimber,config->with_tillage,config->irrig_scenario,npft,ncft,cft,year);
            flux_estab.carbon+=flux_return.carbon;
            flux_estab.nitrogen+=flux_return.nitrogen;

            /*if(setasidestand->type->landusetype!=SETASIDE)
              break;*/
#ifndef DOUBLE_HARVEST
              cell->output.sdate[cft+ncft]=day;
#endif
          }
        }/*of irrigated CFTs*/
      }
    }
  }
  return flux_estab;
}
