/***************************************************************************/
/**                                                                       **/
/**       d  a  i  l  y  _  a  g  r  i  c  u  l  t  u  r  e  .  c         **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function of NPP update of agriculture stand                       **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     See file AUTHORS for list of authors contributing to this code    **/
/**                                                                       **/
/**     Last change: $Date:: 2019-07-10 16:31:39 +0200 (Wed, 10 Jul 201#$ **/
/**     By         : $Author:: felutz                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "crop.h"
#include "natural.h"
#include "agriculture.h"

/*static Bool findcft(const Stand *stand,const char *name)
{
  const Pft *pft;
  int p;
  foreachpft(pft, p, &stand->pftlist)
   if(!strcmp(pft->par->name,name))
     return TRUE;
  return FALSE;
}*/

Real daily_agriculture(Stand *stand, /* stand pointer */
  Real co2,   /* atmospheric CO2 (ppmv) */
  Dailyclimate climate, /* Daily climate values */
  int day,    /* day (1..365) */
  Real daylength, /* length of day (h) */
  const Real gp_pft[], /* pot. canopy conductance for PFTs & CFTs*/
  Real gtemp_air,  /* value of air temperature response function */
  Real gtemp_soil, /* value of soil temperature response function */
  Real gp_stand,
  Real gp_stand_leafon, /* pot. canopy conduct.at full leaf cover */
  Real pet,   /* potential evapotranspiration (mm) */
  Real par,   /* photosynthetic active radiation flux */
  Real melt,  /* melting water (mm) */
  int npft,   /* number of natural PFTs */
  int ncft,   /* number of crop PFTs   */
  int year,
  Bool withdailyoutput,
  Bool UNUSED(intercrop),
  const Config *config /* LPJ config */
)            /* returns runoff (mm) */
{
  int p, l;
  Pft *pft;
  Real aet_stand[LASTLAYER];
  Real green_transp[LASTLAYER];
  Real evap, evap_blue, rd, gpp, frac_g_evap, runoff, wet_all, intercept, sprink_interc;
  Real rw_apply; /*applied irrigation water from rainwater harvesting storage, counted as green water */
  Real *wet; /* wet from pftlist */
  Real return_flow_b; /* irrigation return flows from surface runoff, lateral runoff and percolation (mm)*/
  Real cover_stand;
  Real rainmelt, irrig_apply;
  Real intercep_stand; /* total stand interception (rain + irrigation) (mm)*/
  Real intercep_stand_blue; /* irrigation interception (mm)*/
  Real npp; /* net primary productivity (gC/m2) */
  Real gc_pft;
  Real wdf; /* water deficit fraction */
  Bool negbm;
  Irrigation *data;
  Output *output;
  Real rootdepth = 0;
  Pftcrop *crop;
  irrig_apply = 0.0;


  forrootmoist(l) rootdepth += soildepth[l];
  data = stand->data;
  negbm = FALSE;
  output = &stand->cell->output;
  cover_stand = intercep_stand = intercep_stand_blue = wet_all = intercept = rw_apply = sprink_interc = rainmelt = irrig_apply = 0.0;
  evap = evap_blue = runoff = return_flow_b = 0.0;
  /* if detailed sim, specify tillage day*/
//#ifdef DETAILED_SIM 
  if (param.detail_tillage) {
    /*colorado*/
    if (config->with_tillage)
    {
      if (stand->cell->coord.lat<40.76 && stand->cell->coord.lat>40.74) {
        if ((year > 1950  && year < 1999) && day == 300 || day== 30) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 1999 && day == 120 || year == 1999 && day == 130 || year == 1999 && day == 270) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2000 && day == 108 || year == 2000 && day == 118 || year == 2000 && day == 300) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2001 && day == 108 || year == 2001 && day == 120 || year == 2001 && day == 357) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2002 && day == 104 || year == 2002 && day == 114 || year == 2002 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2003 && day == 109 || year == 2003 && day == 119 || year == 2003 && day == 333) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2004 && day == 109 || year == 2004 && day == 119 || year == 2004 && day == 354) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2005 && day == 109 || year == 2005 && day == 119 || year == 2005 && day == 333) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2006 && day == 108 || year == 2006 && day == 118 || year == 2006 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2007 && day == 118 || year == 2007 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2008 && day == 125 || year == 2008 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2009 && day == 120 || year == 2009 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2010 && day == 124 || year == 2010 && day == 330) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
      }
      /*nebraska*/
      if (stand->cell->coord.lat<41.26 && stand->cell->coord.lat>41.24) {
        if (year == 2001 && day == 116 || year == 2001 && day == 149 || year == 2001 && day == 318) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if ((year > 1950 && year<1998) && day == 115) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }

        if (year == 2002 && day == 114 || year == 2002 && day == 163 || year == 2002 && day == 293) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2003 && day == 112 || year == 2003 && day == 168 || year == 2003 && day == 296) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2004 && day == 110 || year == 2004 && day == 159 || year == 2004 && day == 298) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2005 && day == 122 || year == 2005 && day == 167 || year == 2005 && day == 305) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2006 && day == 127 || year == 2006 && day == 163 || year == 2006 && day == 303) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2007 && day == 114 || year == 2007 && day == 157 || year == 2007 && day == 324) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2008 && day == 119 || year == 2008 && day == 171 || year == 2008 && day == 336) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2009 && day == 111 || year == 2009 && day == 335) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2010 && day == 104 || year == 2010 && day == 168 || year == 2010 && day == 314) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        /*2011 has no tillage event*/
        if (year == 2012 && day == 114) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2013 && day == 121) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if (year == 2014 && day == 114 || 2015 && day == 114) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
      }
      /*michigan*/
      if (stand->cell->coord.lat<42.26 && stand->cell->coord.lat>42.24) {
        if ((year == 1871 || year == 1874 || year == 1877 || year == 1880 || year == 1883 || year == 1886 ||
          year == 1889 || year == 1892 || year == 1895 || year == 1898 || year == 1901 || year == 1904 ||
          year == 1907 || year == 1910 || year == 1913 || year == 1916 || year == 1919 || year == 1922 ||
          year == 1925 || year == 1928 || year == 1931 || year == 1934 || year == 1937 || year == 1940 ||
          year == 1943 || year == 1944 || year == 1946 || year == 1947 || year == 1949 || year == 1950) && day == 105) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }

        if ((year == 1872 || year == 1875 || year == 1878 || year == 1881 || year == 1884 || year == 1887 ||
          year == 1890 || year == 1893 || year == 1896 || year == 1899 || year == 1902 || year == 1905 ||
          year == 1908 || year == 1911 || year == 1914 || year == 1917 || year == 1920 || year == 1923 ||
          year == 1926 || year == 1929 || year == 1932 || year == 1935 || year == 1938 || year == 1941 ||
          year == 1945 || year == 1948 || year == 1951) && day == 75) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        
        if ((year > 1951 && year < 1983) && day == 135) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }

        if (findcft(stand, "maize")) { /*if we have maize*/
          if (year == 1989 && day == 130 || year == 1989 && day == 145 || year == 1989 && day == 182 || year == 1989 && day == 213 || year == 1989 && day == 280) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1991 && day == 145 || year == 1991 && day == 149) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1993 && day == 136 || year == 1993 && day == 139) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          /*no tillage in 1996 and 1999*/
          if (year == 2002 && day == 109 || year == 2002 && day == 128 || year == 2002 && day == 148 || year == 2002 && day == 170) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2005 && day == 115 || year == 2005 && day == 123 || year == 2005 && day == 124) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2008 && day == 126 || year == 2008 && day == 130 || year == 2008 && day == 163) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
        }
        if (!findcft(stand, "maize")) { /*if we have soybean or wheat */
          if (year == 1990 && day == 111 || year == 1990 && day == 124 || year == 1990 && day == 195 || year == 1990 && day == 225) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1992 && day == 115 || year == 1992 && day == 122) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1994 && day == 117 || year == 1994 && day == 139 || year == 1994 && day == 127 || year == 1994 && day == 195 || year == 1994 && day == 225) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 1997 && day == 109 || year == 1997 && day == 127 || year == 1997 && day == 135 || year == 1997 && day == 165 || year == 1997 && day == 179) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2000 && day == 123 || year == 2000 && day == 129 || year == 2000 && day == 139 || year == 2000 && day == 181) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2003 && day == 124 || year == 2003 && day == 148 || year == 2003 && day == 283 || year == 2003 && day == 335 || year == 2003 && day == 364) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2006 && day == 121 || year == 2006 && day == 145) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
          if (year == 2009 && day == 135 || year == 2009 && day == 140 || year == 2009 && day == 309) {
            tillage(stand, param.residue_frac);
            printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          }
        }
      }
      /*france*/
      if (stand->cell->coord.lat<48.76 && stand->cell->coord.lat>48.74) {
        if ((year > 1900 && year < 1971) && day == 323) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }

        if ((year == 1971 || year == 1973 || year == 1975 || year == 1977 || year == 1979 || year == 1981 || year == 1983 || year == 1985
          || year == 1987 || year == 1989 || year == 1991 || year == 1993 || year == 1995
          || year == 1997 || year == 1999 || year == 2001 || year == 2003) && day == 301) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
        }
        if ((year == 1972 || year == 1974 || year == 1976 || year == 1978 || year == 1980 || year == 1982 || year == 1984 || year == 1986
          || year == 1988 || year == 1990 || year == 1992 || year == 1994 || year == 1996
          || year == 1998 || year == 2000 || year == 2002 || year == 2004) && day == 323) {
          tillage(stand, param.residue_frac);
          printf("det: till is done on day %d in year %d in daily_agriculture.c\n", day, year);
          printf("double check if years are correct\n");
        }
      }
    }
  }/*if detailed tillage*/
//#endif
  
  if (getnpft(&stand->pftlist) > 0)
  {
    wet = newvec(Real, getnpft(&stand->pftlist)); /* wet from pftlist */
    check(wet);
    for (p = 0; p < getnpft(&stand->pftlist); p++)
      wet[p] = 0;
  }
  else
    wet = NULL;
  for (l = 0; l < LASTLAYER; l++)
    aet_stand[l] = green_transp[l] = 0;

  if (!config->river_routing)
    irrig_amount(stand, config->pft_output_scaled, npft, ncft);

  foreachpft(pft, p, &stand->pftlist)
  {
    if (!config->with_nitrogen) {
      pft->vscal = 1;
    } else {
      /* trigger 2nd fertilization */
      crop = pft->data;

/*if we do not have detailed fert, do second application, otherwise apply fert on specific days*/
//#ifndef DETAILED_SIM      
      if (!param.detail_fert) {
        if (crop->fphu > 0.4 && crop->nfertilizer > 0) {
          stand->soil.NO3[0] += crop->nfertilizer*0.5;
          stand->soil.NH4[0] += crop->nfertilizer*0.5;
          stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
          printf("glob: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
          crop->nfertilizer = 0;
        
        }
      }
//#else
      if (param.detail_fert) {
        /*colorado*/
        if (stand->cell->coord.lat<40.76 && stand->cell->coord.lat>40.74) {
          if ((year > 1950 && year < 1999) && day == 130) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5 /*split application*/;
            stand->soil.NH4[0] += crop->nfertilizer*0.5 /*split application*/;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
          }
          if (year == 1999 && day == 130) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += crop->nfertilizer*0.78*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            }

          if (year == 2000 && day == 118) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += crop->nfertilizer*0.78*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
          }
          if (year == 2001 && day == 108) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += crop->nfertilizer*0.78*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
          }
          if (year == 2002 && day == 114) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += crop->nfertilizer*0.78*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
          }
          if (year == 2003 && day == 119) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += crop->nfertilizer*0.78*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
          }
          if (year == 2004 && day == 117) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += crop->nfertilizer*0.78*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
          }
          if (year == 2005 && day == 119) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += crop->nfertilizer*0.78*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
          }
          if (year == 2006 && day == 118) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->soil.NH4[0] += crop->nfertilizer*0.5*0.78 /*split application*/;
            stand->cell->balance.n_influx += crop->nfertilizer*0.78*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
          }
          if (year > 1998 && year < 2007) {
            if (day == 160 || day == 190 || day == 210 || day == 240) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.055 /*split application but 4 times, therefore not 0.22*/ ;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.055 /*split application idemditto*/;
            stand->cell->balance.n_influx += crop->nfertilizer*0.055*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              if (day == 240) {
                //stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
                crop->nfertilizer = 0;
              }
            }
          }
        }

        /*nebraska*/

        if (stand->cell->coord.lat<41.26 && stand->cell->coord.lat>41.24) {
          if (findcft(stand, "maize")) {
            if ((year > 1899 && year < 1997) && day == 115) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
          }
          if (findcft(stand, "oil crops soybean")) {
            if ((year > 1899 && year < 1997) && day == 61) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
          }
          if (findcft(stand, "temperate cereals")) {
            if ((year > 1899 && year < 1997) && day == 120) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
          }
          if (year == 2001 && day == 143) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2002 && day == 109) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5;
            stand->soil.NH4[0] += crop->nfertilizer*0.5;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2003 && day == 113) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5;
            stand->soil.NH4[0] += crop->nfertilizer*0.5;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2004 && day == 111) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5;
            stand->soil.NH4[0] += crop->nfertilizer*0.5;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2005 && day == 123) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5;
            stand->soil.NH4[0] += crop->nfertilizer*0.5;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2006 && day == 124) {
            stand->soil.NO3[0] += crop->nfertilizer*0.5;
            stand->soil.NH4[0] += crop->nfertilizer*0.5;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2007 && day == 156) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2008 && day == 170) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2009 && day == 168) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2010 && day == 167) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2011 && day == 165) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2012 && day == 156) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2013 && day == 168) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2014 && day == 170) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
          if (year == 2015 && day == 174) {
            stand->soil.NO3[0] += crop->nfertilizer * 0;
            stand->soil.NH4[0] += crop->nfertilizer * 1;
            stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
            printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            crop->nfertilizer = 0;
          }
        }

        /*michigan*/

        if (stand->cell->coord.lat<42.26 && stand->cell->coord.lat>42.24) {
          if (findcft(stand, "maize")) {
            if ((year==1943 || year == 1944 || year == 1946 || year == 1947 || year == 1949 || year == 1950 || year == 1952 ||
              year == 1953 || year == 1954 || year == 1955 || year == 1956 || year == 1957 || year == 1958 || year == 1959
              || year == 1960 || year == 1961 || year == 1962 || year == 1964 || year == 1966 || year == 1968 || year == 1970
              || year == 1972 || year == 1974 || year == 1976 || year == 1978 || year == 1980) && day == 136) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }

            if (year == 1989 && day == 177) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
            if (year == 1991 && day == 166) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
            if (year == 1993 && day == 182) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
            if (year == 1996 && day == 179) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.83;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.83;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
             }
            if (year == 1996 && day == 135) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.17;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.17;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            }
            if (year == 1999 && day == 181) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.8;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.8;
              stand->cell->balance.n_influx += crop->nfertilizer*0.8*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
                         }
            if (year == 1999 && day == 139) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.2;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.2;
              stand->cell->balance.n_influx += crop->nfertilizer*0.2*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            }
            if (year == 2002 && day == 182) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.83;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.83;
              stand->cell->balance.n_influx += crop->nfertilizer*0.83*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0; 
            }
            if (year == 2002 && day == 130) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.17;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.17;
              stand->cell->balance.n_influx += crop->nfertilizer*0.17*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            }
            if (year == 2005 && day == 171) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.79;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.79;
              stand->cell->balance.n_influx += crop->nfertilizer*0.79*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
            if (year == 2005 && day == 124) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.21;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.21;
              stand->cell->balance.n_influx += crop->nfertilizer*0.21*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            }
            if (year == 2008 && day == 166) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.79;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.79;
              stand->cell->balance.n_influx += crop->nfertilizer*0.79*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
            if (year == 2008 && day == 130) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.21;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.21;
              stand->cell->balance.n_influx += crop->nfertilizer*0.21*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            }
          }
          if (findcft(stand, "temperate cereals")) {
            if (year == 1995 && day == 107) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
            if (year == 1998 && day == 110) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
            if (year == 2001 && day == 108) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
              }
            if (year == 2001 && day == 95) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.5;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            }
            if (year == 2004 && day == 107) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
            if (year == 2007 && day == 140) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
            if (year == 2010 && day == 111) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.57;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.57;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
            }
            if (year == 2010 && day == 119) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5*0.43;
              stand->soil.NH4[0] += crop->nfertilizer*0.5*0.43;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
          }
          if (findcft(stand, "oil crops soybean")) {
            if (year == 2003 && day == 116) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
          }
        }
        /*france*/
        if (stand->cell->coord.lat<48.76 && stand->cell->coord.lat>48.74) {
          if (findcft(stand, "maize")) {
            if ((year == 1971 || year == 1973 || year == 1975 || year == 1977 || year == 1979 || year == 1981 || year == 1983 || year == 1985
              || year == 1987 || year == 1989 || year == 1991 || year == 1993 || year == 1995
              || year == 1997 || year == 1999 || year == 2001 || year == 2003) && day == 131) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5;
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
          }
          if (findcft(stand, "temperate cereals")) { /*fertilize every other year*/
            if ((year > 1900 && year < 1971) && day == 60) {
              stand->soil.NO3[0] += crop->nfertilizer*0.5; /*g should be cm2*/
              stand->soil.NH4[0] += crop->nfertilizer*0.5;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }

            if ((year == 1972 || year == 1974 || year == 1976 || year == 1978 || year == 1980 || year == 1982 || year == 1984 || year == 1986
              || year == 1988 || year == 1990 || year == 1992 || year == 1994 || year == 1996
              || year == 1998 || year == 2000 || year == 2002 || year == 2004) && day == 49) {
              stand->soil.NO3[0] += crop->nfertilizer*0.25; /*g should be cm2*/
              stand->soil.NH4[0] += crop->nfertilizer*0.25;
              //stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              //crop->nfertilizer = 0;
            }
            if ((year == 1972 || year == 1974 || year == 1976 || year == 1978 || year == 1980 || year == 1982 || year == 1984 || year == 1986
              || year == 1988 || year == 1990 || year == 1992 || year == 1994 || year == 1996
              || year == 1998 || year == 2000 || year == 2002 || year == 2004) && day == 74) {
              stand->soil.NO3[0] += crop->nfertilizer*0.25;
              stand->soil.NH4[0] += crop->nfertilizer*0.25;
              stand->cell->balance.n_influx += crop->nfertilizer*stand->frac;
              printf("det: fert is %g on day %d in year %d in daily_agriculture.c\n", crop->nfertilizer, day, year);
              crop->nfertilizer = 0;
            }
          }
        }
      }
//#endif
    }

    if (phenology_crop(pft, climate.temp, daylength, config->laimax_interpolate))
    {
      fprintf(stdout, "harvest of %s on day %d in year %d \n", pft->par->name, day, year);
      if (pft->par->id == output->daily.cft
        && data->irrigation == output->daily.irrigation)
        output_daily_crop(&(output->daily), pft, 0.0, 0.0);
      crop = pft->data;
#ifdef DOUBLE_HARVEST
      if (output->syear[pft->par->id - npft + data->irrigation*ncft] > epsilon)
        output->syear2[pft->par->id - npft + data->irrigation*ncft] = crop->sowing_year;
      else
        output->syear[pft->par->id - npft + data->irrigation*ncft] = crop->sowing_year;
      if (output->syear2[pft->par->id - npft + data->irrigation*ncft] > epsilon)
        output->hdate2[pft->par->id - npft + data->irrigation*ncft] = day;
      else
        output->hdate[pft->par->id - npft + data->irrigation*ncft] = day;
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_aboveground_biomass + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_aboveground_biomass2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        (crop->ind.leaf.carbon + crop->ind.pool.carbon + crop->ind.so.carbon)*pft->nind);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_aboveground_nitrogen + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_aboveground_nitrogen2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        (crop->ind.leaf.nitrogen + crop->ind.pool.nitrogen + crop->ind.so.nitrogen)*pft->nind);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_pet + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_pet2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->petsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_nir + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_nir2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->nirsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_transp + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_transp2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->transpsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_evap + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_evap2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->evapsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_interc + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_interc2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->intercsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_prec + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_prec2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->precsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->growing_period + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->growing_period2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->lgp);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_srad + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_srad2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->sradsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_airrig + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_airrig2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->pirrww);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_temp + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_temp2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->tempsum);
#else
      output->cft_aboveground_biomass[pft->par->id - npft + data->irrigation*(ncft + NGRASS)] =
        (crop->ind.leaf.carbon + crop->ind.pool.carbon + crop->ind.so.carbon)*pft->nind;
      output->cft_aboveground_nitrogen[pft->par->id - npft + data->irrigation*(ncft + NGRASS)] =
        (crop->ind.leaf.nitrogen + crop->ind.pool.nitrogen + crop->ind.so.nitrogen)*pft->nind;
      output->hdate[pft->par->id - npft + data->irrigation*ncft] = day;
#endif
      harvest_crop(output, stand, pft, npft, ncft,
        config->pft_output_scaled);
      /* return irrig_stor and irrig_amount */
      if (data->irrigation)
      {
        stand->cell->discharge.dmass_lake += (data->irrig_stor + data->irrig_amount)*stand->cell->coord.area*stand->frac;
        stand->cell->balance.awater_flux -= (data->irrig_stor + data->irrig_amount)*stand->frac; /* cell water balance account for cell inflow */
        output->mstor_return += (data->irrig_stor + data->irrig_amount)*stand->frac;

        /* pay back conveyance losses that have already been consumed by transport into irrig_stor, only evaporative conv. losses, drainage conv. losses already returned */
        stand->cell->discharge.dmass_lake += (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap*stand->cell->coord.area*stand->frac;
        stand->cell->balance.awater_flux -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap*stand->frac;
        output->aconv_loss_evap -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap*stand->frac; /* part of global water balance */
        output->aconv_loss_drain -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*(1 - data->conv_evap)*stand->frac; /* not included in global water balance */

        if (config->pft_output_scaled)
        {
          stand->cell->output.cft_conv_loss_evap[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap*stand->frac;
          stand->cell->output.cft_conv_loss_drain[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*(1 - data->conv_evap)*stand->frac;
        }
        else
        {
          stand->cell->output.cft_conv_loss_evap[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap;
          stand->cell->output.cft_conv_loss_drain[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*(1 - data->conv_evap);
        }
        data->irrig_stor = 0;
        data->irrig_amount = 0;
      }
      /* delete PFT from list */
      delpft(&stand->pftlist, p);
      /* adjust index */
      p--;
      stand->type = &kill_stand;
      /*runoff+=stand->soil.rw_buffer;
      stand->soil.rw_buffer=0;
      */
      continue;
    }
  } /* of foreachpft() */

  /* green water inflow */
  rainmelt = climate.prec + melt;
  if (rainmelt < 0)
    rainmelt = 0.0;

  /* blue water inflow*/
  if (data->irrigation && data->irrig_amount > epsilon)
  { /* data->irrigation defines if stand is irrigated in general and not if water is delivered that day, initialized in new_agriculture.c and changed in landusechange.c*/
    irrig_apply = max(data->irrig_amount - rainmelt, 0);  /*irrigate only missing deficit after rain, remainder goes to stor */
    data->irrig_stor += data->irrig_amount - irrig_apply;
    data->irrig_amount = 0.0;
    if (irrig_apply < 1 && data->irrig_system != DRIP)  /* min. irrigation requirement of 1mm */
    {
      data->irrig_stor += irrig_apply;
      irrig_apply = 0.0;
    }
    else
    {
      /* write irrig_apply to output */
      output->mirrig += irrig_apply*stand->frac;
      pft = getpft(&stand->pftlist, 0);
#ifndef DOUBLE_HARVEST
      if (config->pft_output_scaled)
        output->cft_airrig[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] += irrig_apply*stand->frac;
      else
        output->cft_airrig[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] += irrig_apply;
#endif
      if (pft->par->id == output->daily.cft && data->irrigation == output->daily.irrigation)
        output->daily.irrig = irrig_apply;
    }
  }

  /* INTERCEPTION */
  foreachpft(pft, p, &stand->pftlist)
  {
    sprink_interc = (data->irrig_system == SPRINK) ? 1 : 0;

    intercept = interception(&wet[p], pft, pet, climate.prec + irrig_apply*sprink_interc); /* in case of sprinkler, irrig_amount goes through interception */
    wet_all += wet[p] * pft->fpc;
    intercep_stand_blue += (climate.prec + irrig_apply*sprink_interc > epsilon) ? intercept*(irrig_apply*sprink_interc) / (climate.prec + irrig_apply*sprink_interc) : 0; /* blue intercept fraction */
    intercep_stand += intercept;
  }
  irrig_apply -= intercep_stand_blue;
  rainmelt -= (intercep_stand - intercep_stand_blue);

  /* rain-water harvesting*/
  if (!data->irrigation && config->rw_manage && rainmelt < 5)
    rw_apply = rw_irrigation(stand, gp_stand, wet, pet); /* Note: RWH supplementary irrigation is here considered green water */

  /* INFILTRATION and PERCOLATION */
  if (irrig_apply > epsilon)
  {
    runoff += infil_perc_irr(stand, irrig_apply, &return_flow_b, withdailyoutput, config);
    /* count irrigation events*/
    pft = getpft(&stand->pftlist, 0);
    output->cft_irrig_events[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)]++; /* id is consecutively counted over natural pfts, biomass, and the cfts; ids for cfts are from 12-23, that is why npft (=12) is distracted from id */
  }

  runoff += infil_perc_rain(stand, rainmelt + rw_apply, &return_flow_b, withdailyoutput, config); /* NOTE: supplementary irrigation from RWH is considered green water, and does not go through interception */

  foreachpft(pft, p, &stand->pftlist)
  {
    cover_stand += fpar(pft);
    /*
     *  Calculate net assimilation, i.e. gross primary production minus leaf
     *  respiration, including conversion from FPC to grid cell basis.
     *
     */

    gpp = water_stressed(pft, aet_stand, gp_stand, gp_stand_leafon,
      gp_pft[getpftpar(pft, id)], &gc_pft, &rd,
      &wet[p], pet, co2, climate.temp, par, daylength, &wdf, npft, ncft, config);

    if (pft->par->id == output->daily.cft && data->irrigation == output->daily.irrigation)
      output_daily_crop(&output->daily, pft, gpp, rd);

    if (gp_pft[getpftpar(pft, id)] > 0.0)
    {
      output->gcgp_count[pft->par->id - config->nbiomass + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)]++;
      output->pft_gcgp[pft->par->id - config->nbiomass + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] += gc_pft / gp_pft[getpftpar(pft, id)];
    }
    npp = npp_crop(pft, gtemp_air, gtemp_soil, gpp - rd, &negbm, wdf, config->with_nitrogen, &output->daily);
    output->mnpp += npp*stand->frac;
    output->dcflux -= npp*stand->frac;
    output->mgpp += gpp*stand->frac;
    output->mfpar += (fpar(pft)*stand->frac*(1.0 / (1 - stand->cell->lakefrac)))*(1 - beta);
    output->cft_fpar[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] += (fpar(pft)*stand->frac*(1.0 / (1 - stand->cell->lakefrac)))*(1 - beta);
    output->cft_fpar[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] += fpar(pft);

    if (config->pft_output_scaled)
      output->pft_npp[(pft->par->id - config->nbiomass) + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] += npp*stand->frac;
    else
      output->pft_npp[(pft->par->id - config->nbiomass) + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] += npp;
    crop = pft->data;
    crop->lgp += 1;
#ifdef DOUBLE_HARVEST
    if (config->pft_output_scaled)
    {
      crop->petsum += pet*((1 - pft->phen)*1.32 + pft->phen*(1 - wet[p])*1.391 + pft->phen*wet[p] * 1.32)*stand->frac;
      crop->precsum += climate.prec*stand->frac;
      crop->sradsum += climate.swdown*stand->frac;
      crop->tempsum += climate.temp*stand->frac;
      crop->pirrww += data->irrig_amount*stand->frac;
    }
    else
    {
      crop->petsum += pet*((1 - pft->phen)*1.32 + pft->phen*(1 - wet[p])*1.391 + pft->phen*wet[p] * 1.32);
      crop->precsum += climate.prec;
      crop->sradsum += climate.swdown;
      crop->tempsum += climate.temp;
      crop->pirrww += data->irrig_amount;
    }

#else
    output->growing_period[pft->par->id - npft + data->irrigation*(ncft + NGRASS)] += 1.;
    output->cft_pet[pft->par->id - npft + data->irrigation*(ncft + NGRASS)] += pet;
    output->cft_temp[pft->par->id - npft + data->irrigation*(ncft + NGRASS)] += climate.temp >= 5 ? climate.temp : 0;
    output->cft_prec[pft->par->id - npft + data->irrigation*(ncft + NGRASS)] += climate.prec;
    output->cft_srad[pft->par->id - npft + data->irrigation*(ncft + NGRASS)] += climate.swdown;
#endif
    if (negbm)
    {
#ifdef DOUBLE_HARVEST
      if (output->syear[pft->par->id - npft + data->irrigation*ncft] > epsilon)
        output->syear2[pft->par->id - npft + data->irrigation*ncft] = crop->sowing_year;
      else
        output->syear[pft->par->id - npft + data->irrigation*ncft] = crop->sowing_year;
      if (output->syear2[pft->par->id - npft + data->irrigation*ncft] > epsilon)
        output->hdate2[pft->par->id - npft + data->irrigation*ncft] = day;
      else
        output->hdate[pft->par->id - npft + data->irrigation*ncft] = day;
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_aboveground_biomass + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_aboveground_biomass2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        (crop->ind.leaf.carbon + crop->ind.pool.carbon + crop->ind.so.carbon)*pft->nind);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_aboveground_nitrogen + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_aboveground_nitrogen2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        (crop->ind.leaf.carbon + crop->ind.pool.carbon + crop->ind.so.carbon)*pft->nind);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_pet + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_pet2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->petsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_nir + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_nir2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->nirsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_transp + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_transp2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->transpsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_evap + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_evap2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->evapsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_interc + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_interc2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->intercsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_prec + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_prec2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->precsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->growing_period + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->growing_period2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->lgp);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_srad + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_srad2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->sradsum);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_airrig + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        output->cft_airrig2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)),
        crop->pirrww);
      double_harvest(output->syear2[pft->par->id - npft + data->irrigation*ncft],
        output->cft_temp + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        output->cft_temp2 + (pft->par->id - npft + data->irrigation*(ncft + NGRASS)),
        crop->tempsum);
#else
      output->cft_aboveground_biomass[pft->par->id - npft + data->irrigation*(ncft + NGRASS)] =
        (crop->ind.leaf.carbon + crop->ind.pool.carbon + crop->ind.so.carbon)*pft->nind;
      output->cft_aboveground_nitrogen[pft->par->id - npft + data->irrigation*(ncft + NGRASS)] =
        (crop->ind.leaf.nitrogen + crop->ind.pool.nitrogen + crop->ind.so.nitrogen)*pft->nind;
      output->hdate[pft->par->id - npft + data->irrigation*ncft] = day;
#endif
      harvest_crop(output, stand, pft, npft, ncft, config->pft_output_scaled);
      if (data->irrigation)
      {
        stand->cell->discharge.dmass_lake += (data->irrig_stor + data->irrig_amount)*stand->cell->coord.area*stand->frac;
        stand->cell->balance.awater_flux -= (data->irrig_stor + data->irrig_amount)*stand->frac;
        output->mstor_return += (data->irrig_stor + data->irrig_amount)*stand->frac;

        /* pay back conveyance losses that have already been consumed by transport into irrig_stor */
        stand->cell->discharge.dmass_lake += (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap*stand->cell->coord.area*stand->frac;
        stand->cell->balance.awater_flux -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap*stand->frac;
        output->aconv_loss_evap -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap*stand->frac;
        output->aconv_loss_drain -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*(1 - data->conv_evap)*stand->frac;

        if (config->pft_output_scaled)
        {
          stand->cell->output.cft_conv_loss_evap[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap*stand->frac;
          stand->cell->output.cft_conv_loss_drain[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*(1 - data->conv_evap)*stand->frac;
        }
        else
        {
          stand->cell->output.cft_conv_loss_evap[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*data->conv_evap;
          stand->cell->output.cft_conv_loss_drain[pft->par->id - npft + data->irrigation*(ncft + NGRASS + NBIOMASSTYPE)] -= (data->irrig_stor + data->irrig_amount)*(1 / data->ec - 1)*(1 - data->conv_evap);
        }

        data->irrig_stor = 0;
        data->irrig_amount = 0;
      }
      delpft(&stand->pftlist, p);
      stand->type = &kill_stand;
      /*
      runoff+=stand->soil.rw_buffer;
      stand->soil.rw_buffer=0;
      */
      p--;
      continue;
    }
  } /* of foreachpft */

  /* soil outflow: evap and transpiration */
  waterbalance(stand, aet_stand, green_transp, &evap, &evap_blue, wet_all, pet, cover_stand,
    &frac_g_evap, config->rw_manage);
  if (withdailyoutput)
  {
    foreachpft(pft, p, &stand->pftlist)
      if (pft->par->id == output->daily.cft && data->irrigation == output->daily.irrigation)
      {
        output->daily.evap = evap;
        forrootsoillayer(l) {
          if (l < 3) {
            output->daily.nh4 += stand->soil.NH4[l]; /*as in agmip_wheat4_lpjml5*/
            output->daily.no3 += stand->soil.NO3[l]; /*as in agmip_wheat4_lpjml5*/
           }
        output->daily.trans += aet_stand[l]; /*as in agmip_wheat4_lpjml5*/
        }
/*exclude next lines, as done in lpj_tillage for soilwater calc, see rev 5001*/
       /* output->daily.w0 = stand->soil.w[1];
        output->daily.w1 = stand->soil.w[2];
        output->daily.wevap = stand->soil.w[0];
        output->daily.fw_0 = stand->soil.w_fw[1];*/
        /* output in mm including ice, free water and dead water */

/*next lines are modified to calculate wfps[frac] instead of soil water [mm] by dividing it by wsat*/
output->daily.w0=(stand->soil.w[1] * stand->soil.whcs[1] + stand->soil.w_fw[1] +
 stand->soil.ice_depth[1] + stand->soil.ice_fw[1] + stand->soil.wpwps[1])/ stand->soil.wsats[1];
 output->daily.w1=(stand->soil.w[2] * stand->soil.whcs[2] + stand->soil.w_fw[2] +
  stand->soil.ice_depth[2] + stand->soil.ice_fw[2] + stand->soil.wpwps[2])/ stand->soil.wsats[2];
 output->daily.wevap=(stand->soil.w[0]*stand->soil.whcs[0]+ stand->soil.w_fw[0] +
   stand->soil.ice_depth[0] + stand->soil.ice_fw[0] + stand->soil.wpwps[0])/ stand->soil.wsats[0];
 /*outputs for whc, wsat, fc and wp*/
output->daily.whc = stand->soil.whc[0] / stand->soil.wsat[0];
output->daily.wsat = stand->soil.wsat[0];
output->daily.fc = stand->soil.wfc[0] / stand->soil.wsat[0];
output->daily.wp = stand->soil.wpwp[0] / stand->soil.wsat[0];
output->daily.par=par;
output->daily.daylength=daylength;
output->daily.pet=pet;
output->daily.litter_cover = stand->soil.litter.agtop_cover;
for (l = 0; l < stand->soil.litter.n; l++) {
  output->daily.litter_ag += stand->soil.litter.ag[l].trait.leaf.carbon;
  output->daily.litter_agsub += stand->soil.litter.agsub[l].trait.leaf.carbon;
}
      }
  }
  for (l = 0; l < NTILLLAYER; l++)
  {
    output->daily.whc = stand->soil.whc[l] * stand->frac;
  }

  /* calculate net irrigation requirements (NIR) for next days irrigation */
  if (data->irrigation && stand->pftlist.n > 0) /* second element to avoid irrigation on just harvested fields */
    irrigation_stand(stand, gp_stand, wet, pet);

  foreachsoillayer(l)
    output->mswc[l] += (stand->soil.w[l] * stand->soil.whcs[l] + stand->soil.w_fw[l] + stand->soil.wpwps[l] +
      stand->soil.ice_depth[l] + stand->soil.ice_fw[l]) / stand->soil.wsats[l] * stand->frac*(1.0 / (1 - stand->cell->lakefrac));
  forrootmoist(l)
    output->mrootmoist += stand->soil.w[l] * soildepth[l] / rootdepth*stand->frac*(1.0 / (1 - stand->cell->lakefrac));

  forrootsoillayer(l)
  {
    output->mtransp += aet_stand[l] * stand->frac;
    output->mtransp_b += (aet_stand[l] - green_transp[l])*stand->frac;
  }

  output->minterc += intercep_stand*stand->frac; /* Note: including blue fraction*/
  output->minterc_b += intercep_stand_blue*stand->frac;   /* blue interception and evap */

  output->mevap += evap*stand->frac;
  output->mevap_b += evap_blue*stand->frac;   /* blue soil evap */

  output->mreturn_flow_b += return_flow_b*stand->frac; /* now only changed in waterbalance_new.c*/

  /* output for green and blue water for evaporation, transpiration and interception */
  output_gbw_agriculture(output, stand, frac_g_evap, evap, evap_blue, return_flow_b, aet_stand, green_transp,
    intercep_stand, intercep_stand_blue, npft, ncft, config->pft_output_scaled);
  free(wet);
  //printf("fert %g NO3 %g NH4 %g soilwater %g slowC %g fastC %g phu %g lai %g vscal %g day %d \n",crop->nfertilizer,stand->soil.NO3[0], stand->soil.NH4[0], stand->soil.w[0], stand->soil.pool[0].slow.carbon, stand->soil.pool[0].fast.carbon, crop->phu,crop->lai,crop->vscal_sum,day);
  return runoff;
} /* of 'daily_agriculture' */
