/***************************************************************************/
/**                                                                       **/
/**            c  u  l  t  i  v  a  t  e  .  c                            **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2019-05-10 13:56:46 +0200 (Fri, 10 May 201#$ **/
/**     By         : $Author:: felutz                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "agriculture.h"

Stocks cultivate(Cell *cell,           /* cell pointer */
               const Pftpar *pftpar, /* PFT parameter to be established */
               int vern_date20, 
               Real landfrac,        /* land fraction (0..1) */
               Bool irrigation,      /* irrigated (TRUE/FALSE) */
               int day,              /* day (1..365) */
               Bool wtype,           /* winter type (TRUE/FALSE) */
               Stand *setasidestand,
               Bool istimber,
               Bool istillage,
               int irrig_scenario,   /* irrigation scenario */
               int npft,             /*  number of natural PFTs */
               int ncft,             /*  number of crop PFTs */
               int cft,              /* cft index for set_irrigsystem */
               int year              /* AD */
              )
{
  int pos; /*position of new stand in list*/
  Pft *pft;
  Stand *cropstand;
  Irrigation *data;
  Stocks bm_inc;
  Real split_fert=0.5;
  Pftcrop *crop;
  landfrac = 1.0;


  //fprintf(stdout, "forcing 100% crop frac for %s\n",pft->par->name);
  if(landfrac>=setasidestand->frac-epsilon)
  {
    setasidestand->type->freestand(setasidestand);
    setasidestand->type=&agriculture_stand;
    new_agriculture(setasidestand);
    /* delete all PFTs */
    cutpfts(setasidestand);
//#ifndef DETAILED_SIM 
    if (param.detail_tillage==0) {
      if (istillage) {
          tillage(setasidestand, param.residue_frac);
          printf("glob: till is done on day %d in year %d in cultivate.c\n", day, year);
                }
    }
//#endif*/
    
pos=addpft(setasidestand,pftpar,year,day);
    pft=getpft(&setasidestand->pftlist,pos-1);
    phen_variety(pft,vern_date20,cell->coord.lat,day,wtype,year);
    data=setasidestand->data;
    data->irrigation= irrig_scenario==ALL_IRRIGATION ? TRUE : irrigation;
    set_irrigsystem(setasidestand,cft,0,FALSE); /* calls set_irrigsystem() for landusetype AGRICULTURE only */
    bm_inc.carbon=pft->bm_inc.carbon*setasidestand->frac;
    bm_inc.nitrogen=pft->bm_inc.nitrogen*setasidestand->frac;
//#ifndef DETAILED_SIM
  
      if (param.detail_fert == 0) {
        if (cell->ml.fertilizer_nr != NULL)
        {
          if (cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] > param.nfert_split)
          {
            crop = pft->data;
            crop->nfertilizer = cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] * split_fert; /* keep 50% for 2nd application */
            split_fert = 0.25;

            printf("glob: fert is %g on day %d in year %d in cultivate.c\n", crop->nfertilizer, day, year);

          }
          setasidestand->soil.NO3[0] += cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] * split_fert;
          setasidestand->soil.NH4[0] += cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] * split_fert;
          cell->balance.n_influx += cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] * 2 * split_fert*setasidestand->frac;
        }
      }
      else {
        crop = pft->data;
        crop->nfertilizer = cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft]; /*refer to file name so that it can be read in in daily_agriculture*/
      }
    
//#endif
    return bm_inc;
  }
  else
  {
    pos=addstand(&agriculture_stand,cell);

    cropstand=getstand(cell->standlist,pos-1);
    data=cropstand->data;
    cropstand->frac=landfrac;
    data->irrigation= irrig_scenario==ALL_IRRIGATION ? TRUE : irrigation;
    reclaim_land(setasidestand,cropstand,cell,istimber,npft+ncft);
    set_irrigsystem(cropstand,cft,0,FALSE);
//#ifndef DETAILED_SIM
    if (param.detail_tillage == 0) {
      if (istillage)
      {
              tillage(cropstand, param.residue_frac);
          printf("glob: till is done on day %d in year %d in cultivate.c\n", day, year);
    
       }
    }
//#endif
    pos=addpft(cropstand,pftpar,year,day);
    pft=getpft(&cropstand->pftlist,pos-1);
    phen_variety(pft,vern_date20,cell->coord.lat,day,wtype,year);
    setasidestand->frac-=landfrac;
    bm_inc.carbon=pft->bm_inc.carbon*cropstand->frac;
    bm_inc.nitrogen=pft->bm_inc.nitrogen*cropstand->frac;
//#ifndef DETAILED_FERT    

      if (param.detail_fert == 0) {
        if (cell->ml.fertilizer_nr != NULL)
        {
          if (cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] > param.nfert_split)
          {
            crop = pft->data;
            crop->nfertilizer = cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] * split_fert; /* keep 50% for 2nd application */
            split_fert = 0.25;
            printf("glob: fert is %g on day %d in year %d in cultivate.c\n", crop->nfertilizer, day, year);
          }
          cropstand->soil.NO3[0] += cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] * split_fert;
          cropstand->soil.NH4[0] += cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] * split_fert;
          cell->balance.n_influx += cell->ml.fertilizer_nr[irrigation].crop[pft->par->id - npft] * 2 * split_fert*cropstand->frac;
        }
      }

//#endif    
    return bm_inc;
  }

} /* of 'cultivate' */

/*
- called in sowing()
- comparison of the land fraction (landfrac) of the considered cft with the 
  fraction of the set-aside stand (setasidestand->frac)
  -> is the land fraction of the cft greater or equal as the fraction of the
     set-aside stand:
  -> sets the landusetype of the set-aside stand to AGRICULTURE 
     (defined in stand.h)
  -> kills all pfts of the set-aside stand and updates the litter pools
  -> adds considered cft to the pftlist of the stand (see addpft() in 
     pftlist.h)
     (-> addpft() calls function newpft() (see newpft.c);
      -> newpft() calls specific functions (here new_crop.c, see below)) 
  -> creates a variable crop of type Pftcrop with the informations of the 
     crop-specific variables of the new cft (see getpft() in pftlist.h) 
     with the aim to change informations
  -> calls function phen_variety() (see below)
  -> sets wtype to TRUE or FALSE (this information comes from function sowing())
  -> sets irrigation to TRUE or FALSE (this information comes from function
     sowing())

  -> is the land fraction of the cft smaller as the fraction of the set-aside 
     stand
     -> adds a new stand to the standlist (see addstand() in standlist.c)
     -> addstand() returns the length of the standlist which is also the
        position of the new stand in the standlist
     -> creates a variable cropstand of type Stand with the informations of 
        the new stand (see getstand() in stand.h) with the aim to change 
        informations
     -> calls function reclaim_land()
     -> adds considered cft to the pftlist of the stand (see addpft() in 
        pftlist.h)
     -> creates a variable crop of type Pftcrop with the informations of the
        crop-specific variables of the new cft (see getpft() in pftlist.h) 
        with the aim to change informations
     -> calls function phen_variety() (see below)
     -> sets wtype to TRUE or FALSE (this information comes from function 
        sowing())
     -> sets the landusetype of the new cropstand to AGRICULTURE 
     -> sets irrigation to TRUE or FALSE (this information comes from function
        sowing())
     -> sets the frac of the new cropstand to the landfrac
     -> subtracts the frac of the set-aside stand with the landfrac
*/
