/***************************************************************************/
/**                                                                       **/
/**               v  m  a  x  l  i  m  i  t  _  g  r  a  s  s  .  c       **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von BLoh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-23 12:38:53 +0100 (Thu, 23 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

Real vmaxlimit_grass(const Pft *pft, /* pointer to PFT */
                     Real daylength, /* day length (h) */
                     Real temp       /* temperature (deg C) */
                    )                /* returns vmax (gC/m2/day) */
{
  const Pftgrass *grass;
  grass=pft->data; 
  //return (n_leaf-param.n0*0.001*(grass->ind.leaf.carbon+pft->bm_inc.carbon*grass->falloc.leaf))/exp(-0.0555*(temp-25))/f_lai(lai_grass(pft))/param.p/0.02314815*daylength;
  return (grass->ind.leaf.nitrogen-param.n0*0.001*(grass->ind.leaf.carbon))/exp(-param.k_temp*(temp-25))/f_lai(lai_grass(pft))/param.p/0.02314815*daylength;
  } /* of 'vmaxlimit_grass' */
