/***************************************************************************/
/**                                                                       **/
/**           v  e  g  _  s  u  m  _  g  r  a  s  s  .  c                 **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-11-30 11:28:39 +0100 (Wed, 30 Nov 201#$ **/
/**     By         : $Author:: cmueller                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

Real vegc_sum_grass(const Pft *pft)
{
  const Pftgrass *grass;
  grass=pft->data;
  return (phys_sum_grass(grass->ind)+grass->excess_carbon)*pft->nind;
} /* of 'vegc_sum_grass' */

Real vegn_sum_grass(const Pft *pft)
{
  const Pftgrass *grass;
  grass=pft->data;
  return phys_sum_grass_n(grass->ind)*pft->nind+pft->bm_inc.nitrogen;
} /* of 'vegn_sum_grass' */
