/***************************************************************************/
/**                                                                       **/
/**        t u r n o v e r _ m o n t h l y _ g r a s s . c                **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2014-08-14 13:48:01 +0200 (Thu, 14 Aug 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

void turnover_monthly_grass(Litter *litter,Pft *pft)
{
  Pftgrass *grass;
  Pftgrasspar *grasspar;
  if(pft->stand->type->landusetype==NATURAL)
  {
    grasspar=pft->par->data;
    grass=pft->data;
    grass->turn.root.carbon+=grass->ind.root.carbon*grasspar->turnover.root/NMONTH;
    litter->bg[pft->litter].carbon+=grass->ind.root.carbon*grasspar->turnover.root/NMONTH*pft->nind;
    grass->turn.root.nitrogen+=grass->ind.root.nitrogen*grasspar->turnover.root/NMONTH;
    litter->bg[pft->litter].nitrogen+=grass->ind.root.nitrogen*grasspar->turnover.root/NMONTH*pft->nind*pft->par->fn_turnover;
  }
} /* of 'turnover_monthly_grass' */
