/***************************************************************************/
/**                                                                       **/
/**                       n  e  w  _  g  r  a  s  s  .  c                 **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function allocates and initializes grass-specific variables       **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-11-30 11:28:39 +0100 (Wed, 30 Nov 201#$ **/
/**     By         : $Author:: cmueller                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

void new_grass(Pft *pft, /* pointer to PFT variables */
               int UNUSED(year),
               int UNUSED(day)
              )        
{
  Pftgrass *grass;
  Pftgrasspar *grasspar;
  grass=new(Pftgrass);
  check(grass);
  pft->data=grass;
  grasspar=pft->par->data;
  pft->bm_inc.carbon=pft->wscal_mean=pft->phen=0;
  pft->bm_inc.nitrogen=0;
  pft->stand->growing_days=0;
#ifdef NEW_GRASS
  grass->max_leaf=0;
#endif
  grass->excess_carbon=0;
  pft->nind=1;
  pft->flaimax=0;
  pft->vmax=0;
  pft->stand->growing_days=0; /* initialize growing days to zero for stand */
  grass->falloc.leaf=grasspar->sapl.leaf.carbon/(grasspar->sapl.leaf.carbon+grasspar->sapl.root.carbon);
  grass->falloc.root=grasspar->sapl.root.carbon/(grasspar->sapl.leaf.carbon+grasspar->sapl.root.carbon);
  grass->ind.leaf.carbon=grass->ind.root.carbon=grass->turn.leaf.carbon=grass->turn.root.carbon=0;
  grass->ind.leaf.nitrogen=grass->ind.root.nitrogen=grass->turn.leaf.nitrogen=grass->turn.root.nitrogen=0;
} /* of 'new_grass' */
