/***************************************************************************/
/**                                                                       **/
/**     m  i  x  _  v  e  g  _  g  r  a  s  s  .  c                       **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 27.09.2004                                           **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

void mix_veg_grass(Pft *pft,Real scaler)
{
  Pftgrass *grass;
  grass=pft->data;
  
  grass->ind.leaf.carbon*=scaler;
  grass->ind.root.carbon*=scaler;
  grass->turn.root.carbon*=scaler;
  grass->turn.leaf.carbon*=scaler;
  grass->ind.leaf.nitrogen*=scaler;
  grass->ind.root.nitrogen*=scaler;
  grass->turn.root.nitrogen*=scaler;
  grass->turn.leaf.nitrogen*=scaler;

  pft->bm_inc.carbon*=scaler;
  pft->bm_inc.nitrogen*=scaler;
  
} /* of 'mix_veg_grass' */
