/***************************************************************************/
/**                                                                       **/
/**     l  i  t  t  e  r  _  u  p  d  a  t  e  _  g  r  a  s  s  .  c     **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2015-11-25 11:03:12 +0100 (Wed, 25 Nov 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

void litter_update_grass(Litter *litter, /* Litter pool */
                         Pft *pft,       /* PFT variables */
                         Real frac      /* fraction (0..1) */
                        )
{
  Pftgrass *grass;
  grass=pft->data;
  litter->ag[pft->litter].trait.leaf.carbon+=grass->ind.leaf.carbon*frac;
  litter->ag[pft->litter].trait.leaf.nitrogen+=grass->ind.leaf.nitrogen*frac;
  litter->ag[pft->litter].trait.leaf.nitrogen+=pft->bm_inc.nitrogen*frac;
  update_fbd_grass(litter,pft->par->fuelbulkdensity,
                   grass->ind.leaf.carbon*frac);
  litter->bg[pft->litter].carbon+=grass->ind.root.carbon*frac;
  litter->bg[pft->litter].nitrogen+=grass->ind.root.nitrogen*frac;
//  pft->bm_inc.nitrogen*=(1-frac);

} /* of 'litter_update_grass' */
