/***************************************************************************/
/**                                                                       **/
/**           l  i  g  h  t  _  g  r  a  s  s  .  c                       **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-10-20 10:39:12 +0200 (Thu, 20 Oct 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

void light_grass(Litter *litter,Pft *pft,Real excess)

{
  Grassphys  m_kill; /* reduction in grass PFT mass to reduce grass cover
                        to permitted maximum (gC)*/
  Stocks lm_old;
  Pftgrass *grass;
  grass=pft->data;
  
  lm_old.carbon=grass->ind.leaf.carbon;
  lm_old.nitrogen=grass->ind.leaf.nitrogen;
  grass->ind.leaf.carbon=-2.0*log(1.0-(pft->fpc-excess))/getpftpar(pft,sla);
  if(grass->ind.leaf.nitrogen>0)
    grass->ind.leaf.nitrogen=-2.0*log(1.0-(pft->fpc-excess))/getpftpar(pft,sla)*grass->ind.leaf.nitrogen/lm_old.carbon;
  m_kill.leaf.carbon=lm_old.carbon-grass->ind.leaf.carbon;
  if(lm_old.carbon>0)
    m_kill.root.carbon=grass->ind.root.carbon*(m_kill.leaf.carbon/lm_old.carbon);
  else 
    m_kill.root.carbon=m_kill.leaf.carbon*getpftpar(pft,lmro_ratio);
  m_kill.leaf.nitrogen=lm_old.nitrogen-grass->ind.leaf.nitrogen;
  if(lm_old.nitrogen>epsilon)
    m_kill.root.nitrogen=grass->ind.root.nitrogen*(m_kill.leaf.nitrogen/lm_old.nitrogen);
  else
    m_kill.root.nitrogen=0;
  grass->ind.root.carbon-=m_kill.root.carbon;
  grass->ind.root.nitrogen-=m_kill.root.nitrogen;
  litter->ag[pft->litter].trait.leaf.carbon+=m_kill.leaf.carbon;
  litter->ag[pft->litter].trait.leaf.nitrogen+=m_kill.leaf.nitrogen;
  update_fbd_grass(litter,pft->par->fuelbulkdensity,m_kill.leaf.carbon);
  litter->bg[pft->litter].carbon+=m_kill.root.carbon;
  litter->bg[pft->litter].nitrogen+=m_kill.root.nitrogen;
  fpc_grass(pft);
} /* of 'light_grass' */
