/***************************************************************************/
/**                                                                       **/
/**               f  s  c  a  n  p  f  t  _  g  r  a  s  s  .  c          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-01 09:28:07 +0100 (Wed, 01 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

#define fscanreal2(isout,file,var,pft,name) \
  if(fscanreal(file,var,name,isout)) \
  { \
    if(isout)\
    fprintf(stderr,"ERROR110: Cannot read PFT '%s' in %s().\n",pft,__FUNCTION__); \
    return TRUE; \
  }

#define fscangrassphys2(isout,file,var,pft,name) \
  if(fscangrassphys(file,var,isout))\
  { \
    if(isout)\
    fprintf(stderr,"ERROR111: Cannot read '%s' of PFT '%s' in %s().\n",name,pft,__FUNCTION__); \
    return TRUE; \
  }

#define fscanpftphenpar(isout,file,var,pft,name) \
  if(fscanphenparam(file,var,isout)) \
  { \
    if(isout)\
    fprintf(stderr,"ERROR112: Cannot read phenology param '%s' of PFT '%s' in %s().\n",name,pft,__FUNCTION__); \
    return TRUE; \
  }

static Bool fscangrassphys(FILE *file,Grassphyspar *phys,Bool isout)
{
  if(fscanreal(file,&phys->leaf,"leaf",isout))
    return TRUE;
  if(fscanreal(file,&phys->root,"root",isout))
    return TRUE;
  if(phys->leaf<=0 ||  phys->root<=0)
    return TRUE;
  return FALSE;
} /* of 'fscangrassphys' */

Bool fscanpft_grass(FILE *file,          /* file pointer */
                    Pftpar *pft,         /* Pointer to Pftpar array */
                    Bool isout
                   )                     /* returns FALSE for success  */
{
  Pftgrasspar *grass;
  pft->newpft=new_grass;
  pft->npp=npp_grass;
  /*pft->fpc=fpc_grass; */
  pft->fpar=fpar_grass;
  pft->alphaa_manage=alphaa_grass;
  pft->leaf_phenology=phenology_grass;
  pft->fwrite=fwrite_grass;
  pft->mix_veg=mix_veg_grass;
  pft->fire=fire_grass;
  pft->fprint=fprint_grass;
  pft->fread=fread_grass;
  pft->litter_update=litter_update_grass;
  pft->annual=annual_grass;
  pft->establishment=establishment_grass;
  pft->reduce=reduce_grass;
  pft->actual_lai=actual_lai_grass;
  pft->init=init_grass;
  pft->free=free_grass;
  pft->vegc_sum=vegc_sum_grass;
  pft->vegn_sum=vegn_sum_grass;
  pft->fprintpar=fprintpar_grass;
  pft->livefuel_consumption=livefuel_consum_grass;
  pft->turnover_monthly=turnover_monthly_grass;
  pft->turnover_daily = turnover_daily_grass;
  pft->albedo=albedo_grass;
  pft->nuptake=nuptake_grass;
  pft->ndemand=ndemand_grass;
  pft->vmaxlimit=vmaxlimit_grass;
  /* read new phenology parameters */
  fscanpftphenpar(isout, file, &pft->tmin, pft->name, "tmin");
  fscanpftphenpar(isout, file, &pft->tmax, pft->name, "tmax");
  fscanpftphenpar(isout, file, &pft->light, pft->name, "light");
  fscanpftphenpar(isout, file, &pft->wscal, pft->name, "wscal");
  grass=new(Pftgrasspar);
  check(grass);
  pft->data=grass;
  fscangrassphys2(isout,file,&grass->turnover,pft->name,"turnover");
  grass->turnover.leaf=1.0/grass->turnover.leaf;
  grass->turnover.root=1.0/grass->turnover.root;
  fscangrassphys2(isout,file,&grass->cn_ratio,pft->name,"cn_ratio");
  fscanreal2(isout,file,&grass->ratio,pft->name,"ratio");
  fscanreal2(isout,file,&grass->reprod_cost,pft->name,"reprod_cost");
  grass->cn_ratio.leaf=1/grass->cn_ratio.leaf;
  grass->cn_ratio.root=1/grass->cn_ratio.root;
  grass->sapl.leaf.carbon=pft->lai_sapl/pft->sla;
  grass->sapl.root.carbon=(1.0/pft->lmro_ratio)*grass->sapl.leaf.carbon;
  grass->sapling_C=phys_sum_grass(grass->sapl);

  return FALSE;
} /* of 'fscanpft_grass' */
