/***************************************************************************/
/**                                                                       **/
/**               f  r  e  a  d  _  g  r  a  s  s  .  c                   **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-12-16 15:10:58 +0100 (Fri, 16 Dec 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

Bool fread_grass(FILE *file,Pft *pft,Bool swap)
{
  Pftgrass *grass;
  grass=new(Pftgrass);
  pft->data=grass;
  if(grass==NULL)
    return TRUE;
  freadreal((Real *)&grass->turn,sizeof(Grassphys)/sizeof(Real),swap,file);
#ifdef NEW_GRASS
  freadreal(&grass->max_leaf,1,swap,file);
#endif
  freadreal(&grass->excess_carbon,1,swap,file);
  freadreal((Real *)&grass->ind,sizeof(Grassphys)/sizeof(Real),swap,file);
  return freadreal((Real *)&grass->falloc,sizeof(Grassphyspar)/sizeof(Real),swap,file)!=sizeof(Grassphyspar)/sizeof(Real);
 
  /*fpc_grass(pft); */
} /* of 'fread_grass' */
