/***************************************************************************/
/**                                                                       **/
/**           f  p  r  i  n  t  p  a  r  _  g  r  a  s  s  .  c           **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function prints PFT parameter                                     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2014-06-20 10:02:29 +0200 (Fri, 20 Jun 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

void fprintpar_grass(FILE *file,const Pftpar *par)
{
  const Pftgrasspar *pargrass;
  pargrass=par->data;
  fprintf(file,"turnover:\t%g %g (yr)\n"
               "C:N ratio:\t%g %g\n"
               "rel. ratio:\t%g\n" 
               "reprod cost:\t%g\n",
          pargrass->turnover.leaf,pargrass->turnover.root,
          1/pargrass->cn_ratio.leaf,
          1/pargrass->cn_ratio.root,
          pargrass->ratio,
          pargrass->reprod_cost);
} /* of 'fprintpar_grass' */
