/***************************************************************************/
/**                                                                       **/
/**                 f  p  r  i  n  t  _  g  r  a  s  s  .  c              **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function prints grass-specific state variables in a text file     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-12-16 15:10:58 +0100 (Fri, 16 Dec 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

void fprint_grass(FILE *file,const Pft *pft)
{
  const Pftgrass *grass;
  grass=pft->data;
  fprintf(file,"Mass:\t\t");
  fprintgrassphys(file,grass->ind);
  fprintf(file,"\nExcess carbon:\t%g (gC/m2)\n",grass->excess_carbon);
  fprintf(file,"falloc:\t\t%g %g\n",grass->falloc.leaf,grass->falloc.root);
} /* of 'fprint_grass' */
