/***************************************************************************/
/**                                                                       **/
/**    e  s  t  a  b  l  i  s  h  m  e  n  t  _  g  r  a  s  s  .  c      **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2014-08-14 13:48:01 +0200 (Thu, 14 Aug 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

Stocks establishment_grass(Pft *pft,Real fpc_total,
                           Real UNUSED(fpc_type),int n_est) 
{

  Pftgrass *grass;
  Pftgrasspar *grasspar;
  Real est_pft;
  /* establishment rate for a particular PFT on modelled area 
   * basis (for trees, indiv/m2; for grasses, fraction of 
   * modelled area colonised establishment rate for a particular
   * PFT on modelled area basis (for trees, indiv/m2; for 
   * grasses, fraction of modelled area colonised)
   */
  Stocks acflux_est;
  if(n_est>0)
  {
    grass=pft->data;
    grasspar=getpftpar(pft,data);
    est_pft=(1.0-fpc_total)/(Real)n_est;
    /* Account for flux from atmosphere to grass regeneration */

    acflux_est.carbon=phys_sum_grass(grasspar->sapl)*est_pft;
    acflux_est.nitrogen=acflux_est.carbon*grasspar->cn_ratio.leaf;
    /* Add regeneration biomass to overall biomass */

    grass->ind.leaf.carbon+=grasspar->sapl.leaf.carbon*est_pft;
    grass->ind.root.carbon+=grasspar->sapl.root.carbon*est_pft;
    grass->ind.leaf.nitrogen+=grasspar->sapl.leaf.carbon*grasspar->cn_ratio.leaf*est_pft;
    grass->ind.root.nitrogen+=grasspar->sapl.root.carbon*grasspar->cn_ratio.leaf*est_pft;
    //pft->bm_inc.nitrogen+=acflux_est.nitrogen;
    pft->nleaf=grass->ind.leaf.nitrogen;
  }
  else
    acflux_est.carbon=acflux_est.nitrogen=0;
  fpc_grass(pft);
  return acflux_est;
} /* of 'establishment_grass' */
