/***************************************************************************/
/**                                                                       **/
/**              a  l  p  h  a  a  _  g  r  a  s  s  .  c                 **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     written by Christoph Mueller                                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 12.06.2009                                           **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "grass.h"

Real alphaa_grass(const Pft *pft, int UNUSED(lai_opt))
{    
  Pftgrass *grass;
  Real scaler=1.0;
  grass=pft->data;

  if((grass->ind.leaf.carbon+grass->excess_carbon*grass->falloc.leaf)>10){
    scaler=grass->ind.leaf.nitrogen/(grass->ind.leaf.carbon+grass->excess_carbon*grass->falloc.leaf) /
           pft->par->ncleaf.low;
    if(scaler>1) 
      scaler=1.0;
    else
      scaler=(1+param.par_sink_limit)*scaler/(scaler+param.par_sink_limit);
  }
  return pft->par->alphaa*scaler;
} /* of 'alphaa_grass' */
