/***************************************************************************/
/**                                                                       **/
/**               v  m  a  x  l  i  m  i  t  _  c  r  o  p  .  c          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Werner von BLoh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-23 12:38:53 +0100 (Thu, 23 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "crop.h"

Real vmaxlimit_crop(const Pft *pft, /* pointer to PFT */
                    Real daylength, /* day length (h) */
                    Real temp       /* temperature (deg C) */
                   )                /* returns vmax (gC/m2/day) */
{
  const Pftcrop *crop;
  crop=pft->data; 
#ifdef DEBUG_N
 // printf("LAI=%g, N0=%g\n",lai_crop(pft),param.n0*0.001*crop->ind.leaf.carbon);
#endif
  //return (n_leaf-param.n0*0.001*crop->ind.leaf.carbon)/exp(-0.0555*(temp-25))/f_lai(lai_crop(pft))/param.p/0.02314815*daylength;
  return (crop->ind.leaf.nitrogen-param.n0*0.001*crop->ind.leaf.carbon)/exp(-param.k_temp*(temp-25))/f_lai(lai_crop(pft))/param.p/0.02314815*daylength;
} /* of 'vmaxlimit_crop' */
