/***************************************************************************/
/**                                                                       **/
/**             v  e  g  _  s  u  m  _  c  r  o  p  .  c                  **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2014-11-19 13:49:10 +0100 (Wed, 19 Nov 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "crop.h"

Real vegc_sum_crop(const Pft *pft)
{
  const Pftcrop *crop;
  crop=pft->data;
  /*printf("vegc_sum_crop: %f nind: %f\n",phys_sum_crop(crop->ind)*pft->nind,pft->nind);*/
  return phys_sum_crop(crop->ind)*pft->nind;
} /* of 'vegc_sum_crop' */

Real vegn_sum_crop(const Pft *pft)
{
  const Pftcrop *crop;
  crop=pft->data;
  /*printf("vegc_sum_crop: %f nind: %f\n",phys_sum_crop(crop->ind)*pft->nind,pft->nind);*/
  return phys_sum_crop_n(crop->ind)*pft->nind;
} /* of 'vegn_sum_crop' */
