/***************************************************************************/
/**                                                                       **/
/**             p  h  e  n  _  v  a  r  i  e  t  y  .  c                  **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 25.01.2006  by S.Jachner, M.Gumpenberger             **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "crop.h"

#define KEYDAY_NHEMISPHERE 365 /* last day of driest month (Dec) of northern hemisphere */
#define KEYDAY_SHEMISPHERE 181 /* last day of driest month (Jun) of southern hemisphere */

void phen_variety(Pft *pft,      /* PFT variables */
                  int vern_date20,
                  Real lat,   /* latitude (deg) */
                  int sdate,  /* sowing date (1..365) */
                  Bool wtype,  /* winter type (TRUE/FALSE) */
                  int year
                 )
{
  int keyday,keyday1;
  Pftcrop *crop;
  const Pftcroppar *croppar;
  crop=pft->data;
  croppar=pft->par->data;
  crop->wtype=wtype;
  if(lat>=0)
  {
    keyday=KEYDAY_NHEMISPHERE;
    keyday1=0;
  }
  else
    keyday=keyday1=KEYDAY_SHEMISPHERE;

  if(sdate>365)
    sdate-=365;

  if(croppar->calcmethod_sdate==TEMP_WTYP_CALC_SDATE)
  {
    if(wtype)
    {
      crop->pvd=max(0,min(60,vern_date20-sdate-croppar->pvd));
      crop->phu=max(croppar->phuw.low,-0.1081*pow((sdate-keyday),2)
                +3.1633*(sdate-keyday)+croppar->phuw.high);
    }
    else
    {
      crop->pvd=0;/*max(0,min(60,vern_date20-sdate));*/
      /* quick fix for too long growing periods in the high latitudes */
      crop->phu=min(croppar->phus.high,max(croppar->phus.low,
              max(croppar->basetemp.low,pft->stand->cell->climbuf.atemp_mean20_fix)*200));
    }
  }
  else
  {
    crop->pvd=0;
    crop->phu=min(croppar->phus.high,max(croppar->phus.low,
          max(croppar->basetemp.low,pft->stand->cell->climbuf.atemp_mean20_fix)*167));
 
   /*specify phu values for colorado and michigan in specific years*/
/*not for runs whrere growing season is not specifiedi (global and _gs run)*/
 if (param.detail_phu==1){
printf("reading specific phu values in year %d \n",year);
  /*michigan*/
  if (pft->stand->cell->coord.lat<42.26 && pft->stand->cell->coord.lat>42.24) {
    if (year == 1989 && sdate == 124) {
      crop->phu = 2150;
    }
    if (year == 1991 && sdate == 122) {
      crop->phu = 2300;
    }
    if (year == 1993 && sdate == 127) {
      crop->phu = 2000;
    }
    if (year == 1996 && sdate == 135) {
      crop->phu = 2050;
    }
    if (year == 1999 && sdate == 139) {
      crop->phu = 2050;
    }
    if (year == 2002 && sdate == 128) {
      crop->phu = 2235;
    }
    if (year == 2005 && sdate == 124) {
      crop->phu = 2350;
    }
    if (year == 2008 && sdate == 130) {
      crop->phu = 2150;
    }
  }
  
    /*colorado*/
    if (pft->stand->cell->coord.lat<40.76 && pft->stand->cell->coord.lat>40.74) {
    if (year == 2002 && sdate == 114) {
      crop->phu = 2300;
    }
    if (year == 2003 && sdate == 119) {
      crop->phu = 1975;
    }
    if (year == 2004 && sdate == 119) {
      crop->phu = 2300;
    }
    if (year == 2005 && sdate == 119) {
      crop->phu = 2200;
    }
    if (year == 2006 && sdate == 118) {
      crop->phu = 2250;
    }
  }/*end of colorado*/
}/*end of sowing prescribe*/
}/*end of else*/
  crop->basetemp=min(croppar->basetemp.high,max(croppar->basetemp.low,pft->stand->cell->climbuf.atemp_mean20_fix-3.0));
} /* of 'phen_variety' */

/*
- called in cultivate()
- this function adjusts parameters (pvd,phu,basetemp) for certain cfts (pvd, phu
  for temperate cereals, rapeseed, sunflower; basetemp only for maize) for a
  variety of the phenology between colder and warmer regions
- the parameters pvd, phu.low/high, phu_par, basetemp.low/high are set in pft.par,
  so that only for the above mentioned cfts a variety can be determined
- sets the keydays dependent on n/shemisphere
- brings the local variable sdate (sowing date) to the interval [1,365]
- 3 different determinations of phu (phenological heat units) and pvd
  (vernalization days) dependent of variables vern_date20 and wtype
  -> hints: the parameters phu.low/high are equal for all cfts except for
            temperate cereals,rapeseed,sunflower
            the parameter phu_par is set to 9999 for all cfts except for sunflower
- checks if vernalization days exist (vern_date20>0)
  -> only for temperate cereals, rapeseed possible
  -> if TRUE: checks if cft is a winter type (wtype)

- determination of basetemp (base temperature) dependent on sdate
  -> hint: parameters bastemp.low/high are equal for all cfts except for
           sunflower, so that the basetemp of these cfts is equal to the
           parameters basetemp.low/high (see pft.par)
*/
