/***************************************************************************/
/**                                                                       **/
/**               n  u  p  t  a  k  e  _  c  r  o  p  .  c                **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     written by Guilaume Vilain, Soenke Zaehle, Sibyll Schaphoff       **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2018-05-16 15:15:17 +0200 (Wed, 16 May 201#$ **/
/**     By         : $Author:: herzfeld                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "crop.h"
#include "agriculture.h"

Real nuptake_crop(Soil *soil,
                  Pft *pft,
                  Real *n_plant_demand,
                  Real *ndemand_leaf,
                  int UNUSED(npft),
                  int nbiomass,
                  int ncft
                 )
{

  Pftcrop *crop;
  const Pftcroppar *croppar;
  Irrigation *data;
  Real ndemand_leaf_opt,NO3_up=0;
  Real NCplant=0;
  Real f_NCplant=0;
  Real up_temp_f=0;
  Real totn,nsum;
  Real n_uptake=0;
  Real fixed_n=0;
  Real rootdist_n[LASTLAYER];
  int l;
  getrootdist(rootdist_n,pft->par->rootdist,soil->mean_maxthaw);
  crop=pft->data;
  croppar=pft->par->data;
  data=pft->stand->data;
  if(crop->ind.leaf.carbon+crop->ind.root.carbon==0)
    return 0;
  //fprintcropphys2(stdout,crop->ind,pft->nind);

  NCplant = (crop->ind.leaf.nitrogen + crop->ind.root.nitrogen) / (crop->ind.leaf.carbon + crop->ind.root.carbon); /* Plant's mobile nitrogen concentration, Eq.9, Zaehle&Friend 2010 Supplementary */
  f_NCplant = min(max(((NCplant-pft->par->ncleaf.high)/(pft->par->ncleaf.low-pft->par->ncleaf.high)),0),1); /*Eq.10, Zaehle&Friend 2010 Supplementary*/
  //f_NCplant=1;
#ifdef DEBUG_N
  printf("f_NCplant=%g\n",f_NCplant);
#endif
  ndemand_leaf_opt=*ndemand_leaf;
  nsum=0;
  forrootsoillayer(l)
  {
    totn=(soil->NO3[l]+soil->NH4[l]);
    if(totn > 0 && soil->temp[l]>0)
    //if(totn > 0)
    {
      //up_temp_f = max((0.0326 + 0.0035 * pow(soil->temp[l],1.652) - pow((soil->temp[l]/41.748),7.19)),0); /*Eq. C5 in Smith et al. 2014*/
      up_temp_f = nuptake_temp_fcn(soil->temp[l]);
      //up_temp_f=1;
      //NO3_up = pft->par->vmax_up * totn[l] * (pft->par->kNmin + (1/(totn[l]*pft->par->KNmin))) * up_temp_f * f_NCplant * crop->ind.root.carbon; /*Eq.8, Zaehle&Friend 2010 Supplementary*/
      NO3_up = 2*pft->par->vmax_up*(pft->par->kNmin +totn/(totn+pft->par->KNmin*soil->wsat[l]*soildepth[l]/1000))* up_temp_f * f_NCplant * (crop->ind.root.carbon*pft->nind)/1000; //Smith et al. Eq. C14-C15, Navail=totn
      //NO3_up = 2*pft->par->vmax_up* up_temp_f * (crop->ind.root.carbon*pft->nind)/1000; //Smith et al. Eq. C14-C15, Navail=totn
      //NO3_up = 2*pft->par->vmax_up*up_temp_f ; //Smith et al. Eq. C14-C15, Navail=totn
#ifdef DEBUG_N
      printf("layer %d NO3_up=%g\n",l,NO3_up);
#endif
      /* reducing uptake according to availability */
      if(NO3_up>totn)
          NO3_up=totn;
       n_uptake+=NO3_up*rootdist_n[l];
       nsum+=totn*rootdist_n[l];
    }
  }
  if(nsum==0)
    n_uptake=0;
  if (n_uptake>*n_plant_demand-pft->bm_inc.nitrogen)
    n_uptake=*n_plant_demand-pft->bm_inc.nitrogen;
  if(n_uptake<=0)
    n_uptake=0;
  else
  {
    pft->bm_inc.nitrogen+=n_uptake;
    forrootsoillayer(l)
      if(soil->temp[l]>0)
      {
        soil->NO3[l]-=(soil->NO3[l]*rootdist_n[l]*n_uptake)/nsum;
        soil->NH4[l]-=soil->NH4[l]*rootdist_n[l]*n_uptake/nsum;
        if(soil->NO3[l]<0)
        {
           pft->bm_inc.nitrogen+=soil->NO3[l];
           soil->NO3[l]=0;
        }
        if(soil->NH4[l]<0)
        {
           pft->bm_inc.nitrogen+=soil->NH4[l];
           soil->NH4[l]=0;
        }

#ifdef SAFE
        if (soil->NO3[l]<-epsilon)
          fail(NEGATIVE_SOIL_NO3_ERR,TRUE,"Pixel: %.2f %.2f NO3=%g<0 in layer %d, nuptake=%g, nsum=%g",
               pft->stand->cell->coord.lat,pft->stand->cell->coord.lon,soil->NO3[l],l,n_uptake,nsum);
        if (soil->NH4[l]<-epsilon)
          fail(NEGATIVE_SOIL_NO3_ERR,TRUE,"Pixel: %.2f %.2f NH4=%g<0 in layer %d, nuptake=%g, nsum=%g",
               pft->stand->cell->coord.lat,pft->stand->cell->coord.lon,soil->NH4[l],l,n_uptake,nsum);

#endif

    }
  }
  crop->ndemandsum += max(0, *n_plant_demand - pft->bm_inc.nitrogen);
  if (*n_plant_demand > pft->bm_inc.nitrogen)
  {
    /* no N limitation for N-fixing crops */
    if (pft->par->id == OIL_CROPS_SOYBEAN || pft->par->id == PULSES) {
      fixed_n = *n_plant_demand - pft->bm_inc.nitrogen;
      n_uptake += fixed_n;
      pft->bm_inc.nitrogen = *n_plant_demand;
      pft->stand->cell->output.mbnf += fixed_n*pft->stand->frac;
      pft->vscal = 1;
    }
    else {
      *n_plant_demand = pft->bm_inc.nitrogen;
      *ndemand_leaf = *n_plant_demand*crop->ind.leaf.carbon / (crop->ind.leaf.carbon + (crop->ind.root.carbon / croppar->ratio.root + crop->ind.pool.carbon / croppar->ratio.pool + crop->ind.so.carbon / croppar->ratio.so)); /*these parameters need to be in pft.par and need to be checked as well)*/
      if (ndemand_leaf_opt < epsilon)
        pft->vscal = 1;
      else
        pft->vscal = min(1, (*ndemand_leaf / (ndemand_leaf_opt / (1 + pft->par->knstore)))); /*eq. C20 in Smith et al. 2014, Biogeosciences */
      //*ndemand_leaf=*n_plant_demand/(1+(crop->ind.root.carbon/croppar->ratio.root+crop->ind.pool.carbon/croppar->ratio.pool+crop->ind.so.carbon/croppar->ratio.so)/crop->ind.leaf.carbon); /*these parameters need to be in pft.par and need to be checked as well)*/
    }
  }
  else
    pft->vscal = 1;
  crop->nuptakesum += n_uptake;
#ifdef DEBUG_N
  printf("ndemand=%g,ndemand_opt=%g\n",*ndemand_leaf,ndemand_leaf_opt);
#endif

  //crop->ndemandsum+=max(0,*n_plant_demand-pft->bm_inc.nitrogen);
  //crop->nuptakesum+=n_uptake;
  //printf("nuptake_crop uptake_sum %g uptake %g\n",crop->nuptakesum,n_uptake);
   pft->stand->cell->output.pft_nuptake[(pft->par->id-nbiomass)+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]+=n_uptake;
   pft->stand->cell->balance.n_uptake+=n_uptake*pft->stand->frac;
   if(pft->par->id==pft->stand->cell->output.daily.cft && data->irrigation==pft->stand->cell->output.daily.irrigation)
   {
     pft->stand->cell->output.daily.nuptake=n_uptake;
     pft->stand->cell->output.daily.vscal=pft->vscal;
   }
   return n_uptake;
} /* of 'nuptake_crop' */
