/***************************************************************************/
/**                                                                       **/
/**         h  a  r  v  e  s  t  _  c  r  o  p  .  c                      **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: 08.10.2009                                           **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "agriculture.h"
#include "crop.h"

/*
 *  Called in function daily_agriculture when crop
 *  is harvested
 *
 */
void harvest_crop(Output *output,        /* Output data */
                  Stand *stand,          /* pointer to crop stand */
                  Pft *pft,              /* PFT variables */
                  int npft,              /* number of natural PFTs */
                  int ncft,              /* number of crop PFTs */
                  Bool pft_output_scaled /* pft-specific output scaled with
                                            stand->frac (TRUE/FALSE) */
                 )
{
  Pftcroppar *croppar;
  Harvest harvest;
  Pftcrop *crop;
  Irrigation *data;
  Real fuelratio,bifratio,factor;
  data=stand->data;
  crop=pft->data;
  stand->soil.litter.ag[pft->litter].trait.leaf.carbon+=(crop->ind.leaf.carbon+crop->ind.pool.carbon)*RESIDUES_IN_SOIL;
  stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen+=(crop->ind.leaf.nitrogen+crop->ind.pool.nitrogen)*RESIDUES_IN_SOIL;
  if(!RESIDUES_FIRE)
  {
    harvest.residuals_burnt.carbon=harvest.residuals_burntinfield.carbon=
      harvest.residuals_burnt.nitrogen=harvest.residuals_burntinfield.nitrogen=0;
    factor=(1-RESIDUES_IN_SOIL);
  }
  else
  {
    fuelratio=stand->cell->ml.manage.regpar->fuelratio; /* burn outside of field */
    bifratio=stand->cell->ml.manage.regpar->bifratio; /* burn in field */
    if(bifratio+fuelratio>(1-RESIDUES_IN_SOIL))
    {
      bifratio*=(1-RESIDUES_IN_SOIL);
      fuelratio*=(1-RESIDUES_IN_SOIL);
    }
    factor=1-RESIDUES_IN_SOIL-fuelratio-bifratio;
    harvest.residuals_burnt.carbon=(crop->ind.leaf.carbon+crop->ind.pool.carbon)*fuelratio;
    harvest.residuals_burntinfield.carbon=(crop->ind.leaf.carbon+crop->ind.pool.carbon)*bifratio;
    harvest.residuals_burnt.nitrogen=(crop->ind.leaf.nitrogen+crop->ind.pool.nitrogen)*fuelratio;
    harvest.residuals_burntinfield.nitrogen=(crop->ind.leaf.nitrogen+crop->ind.pool.nitrogen)*bifratio;
  }
  if(param.remove_residuals){
    harvest.residual.carbon=(crop->ind.leaf.carbon+crop->ind.pool.carbon)*factor;
    harvest.residual.nitrogen=(crop->ind.leaf.nitrogen+crop->ind.pool.nitrogen)*factor;
  }
  else
  {
    stand->soil.litter.ag[pft->litter].trait.leaf.carbon+=(crop->ind.leaf.carbon+crop->ind.pool.carbon)*factor;
    stand->soil.litter.ag[pft->litter].trait.leaf.nitrogen+=(crop->ind.leaf.nitrogen+crop->ind.pool.nitrogen)*factor;
    harvest.residual.carbon=harvest.residual.nitrogen=0;
  }
  harvest.harvest.carbon=crop->ind.so.carbon;
  harvest.harvest.nitrogen=crop->ind.so.nitrogen;
  stand->soil.litter.bg[pft->litter].carbon+=crop->ind.root.carbon;
  stand->soil.litter.bg[pft->litter].nitrogen+=crop->ind.root.nitrogen;
#ifdef DOUBLE_HARVEST
  if(pft_output_scaled)
  {
    double_harvest(output->syear2[pft->par->id-npft+data->irrigation*ncft],
      &(output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.carbon),
      &(output->pft_harvest2[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.carbon),harvest.harvest.carbon*stand->frac);
    double_harvest(output->syear2[pft->par->id-npft+data->irrigation*ncft],
      &(output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.nitrogen),
      &(output->pft_harvest2[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.nitrogen),harvest.harvest.nitrogen*stand->frac);
    double_harvest(output->syear2[pft->par->id-npft+data->irrigation*ncft],
      &(output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.carbon),
      &(output->pft_harvest2[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.carbon),(harvest.residual.carbon+harvest.residuals_burnt.carbon+harvest.residuals_burntinfield.carbon)*stand->frac);
    double_harvest(output->syear2[pft->par->id-npft+data->irrigation*ncft],
      &(output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.nitrogen),
      &(output->pft_harvest2[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.nitrogen),(harvest.residual.nitrogen+harvest.residuals_burnt.nitrogen+harvest.residuals_burntinfield.nitrogen)*stand->frac);
  }
  else
  {
    double_harvest(output->syear2[pft->par->id-npft+data->irrigation*ncft],
      &(output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.carbon),
      &(output->pft_harvest2[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.carbon),harvest.harvest.carbon);
    double_harvest(output->syear2[pft->par->id-npft+data->irrigation*ncft],
      &(output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.nitrogen),
      &(output->pft_harvest2[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.nitrogen),harvest.harvest.nitrogen);
    double_harvest(output->syear2[pft->par->id-npft+data->irrigation*ncft],
      &(output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.carbon),
      &(output->pft_harvest2[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.carbon),harvest.residual.carbon+harvest.residuals_burnt.carbon+harvest.residuals_burntinfield.carbon);
    double_harvest(output->syear2[pft->par->id-npft+data->irrigation*ncft],
      &(output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.nitrogen),
      &(output->pft_harvest2[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.nitrogen),harvest.residual.nitrogen+harvest.residuals_burnt.nitrogen+harvest.residuals_burntinfield.nitrogen);
  }
  /* harvested area */
  double_harvest(output->syear2[pft->par->id-npft+data->irrigation*ncft],
    output->cftfrac+pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE),
    output->cftfrac2+pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE),stand->frac);
  if(output->syear2[pft->par->id-npft+data->irrigation*ncft]>0)
    output->sdate2[pft->par->id-npft+data->irrigation*ncft]=crop->sdate;
  else
    output->sdate[pft->par->id-npft+data->irrigation*ncft]=crop->sdate;
#else
  if(pft_output_scaled)
  {
    output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.carbon+=harvest.harvest.carbon*stand->frac;
    output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.carbon+=(harvest.residual.carbon+harvest.residuals_burnt.carbon+harvest.residuals_burntinfield.carbon)*stand->frac;
    output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.nitrogen+=harvest.harvest.nitrogen*stand->frac;
    output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.nitrogen+=(harvest.residual.nitrogen+harvest.residuals_burnt.nitrogen+harvest.residuals_burntinfield.nitrogen)*stand->frac;
  }
  else
  {
    output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.carbon+=harvest.harvest.carbon;
    output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.carbon+=(harvest.residual.carbon+harvest.residuals_burnt.carbon+harvest.residuals_burntinfield.carbon);
    output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].harvest.nitrogen+=harvest.harvest.nitrogen;
    output->pft_harvest[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)].residual.nitrogen+=(harvest.residual.nitrogen+harvest.residuals_burnt.nitrogen+harvest.residuals_burntinfield.nitrogen);
  }
  /* harvested area */
  output->cftfrac[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]=stand->frac;
#endif

  output->cft_nleaf[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]+=crop->ind.leaf.nitrogen;
  output->cft_nlimit[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]+=pft->nlimit/crop->lgp;
  output->cft_cleaf[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]+=crop->ind.leaf.carbon;
  output->cft_nroot[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]+=crop->ind.root.nitrogen;
  output->cft_croot[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]+=crop->ind.root.carbon;
  output->cft_nveg[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]+=vegn_sum(pft);
  output->cft_cveg[pft->par->id-npft+data->irrigation*(ncft+NGRASS+NBIOMASSTYPE)]+=vegc_sum(pft);

  output->flux_harvest.carbon+=(harvest.harvest.carbon+harvest.residual.carbon+harvest.residuals_burnt.carbon+harvest.residuals_burntinfield.carbon)*stand->frac;
  output->flux_rharvest_burnt.carbon+=harvest.residuals_burnt.carbon*stand->frac;
  output->flux_rharvest_burnt_in_field.carbon+=harvest.residuals_burntinfield.carbon*stand->frac;
  output->flux_harvest.nitrogen+=(harvest.harvest.nitrogen+harvest.residual.nitrogen+harvest.residuals_burnt.nitrogen+harvest.residuals_burntinfield.nitrogen)*stand->frac;
  output->flux_rharvest_burnt.nitrogen+=harvest.residuals_burnt.nitrogen*stand->frac;
  output->flux_rharvest_burnt_in_field.nitrogen+=harvest.residuals_burntinfield.nitrogen*stand->frac;
  output->dcflux+=(harvest.harvest.carbon+harvest.residual.carbon+harvest.residuals_burnt.carbon+harvest.residuals_burntinfield.carbon)*stand->frac;
  croppar=pft->par->data;
  if(data->irrigation)
    stand->cell->ml.cropdates[pft->par->id-npft].fallow_irrig=croppar->fallow_days;
  else
    stand->cell->ml.cropdates[pft->par->id-npft].fallow=croppar->fallow_days;
} /* of 'harvest_crop' */
