/***************************************************************************/
/**                                                                       **/
/**                f  r  e  a  d  _  c  r  o  p  .  c                     **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     Function reads crop-specific variables from binary file           **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-12-15 16:06:54 +0100 (Thu, 15 Dec 201#$ **/
/**     By         : $Author:: cmueller                        $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "crop.h"

Bool fread_crop(FILE *file, /* file pointer */
                Pft *pft,   /* PFT data to be read */
                Bool swap   /* if true data is in different byte order */
               )            /* returns TRUE on error */
{
  Pftcrop *crop;
  crop=new(Pftcrop);
  pft->data=crop;
  if(crop==NULL)
    return TRUE;
  freadint1(&crop->wtype,swap,file);
  freadint1(&crop->growingdays,swap,file);
  freadreal1(&crop->pvd,swap,file);
  freadreal1(&crop->phu,swap,file);
  freadreal1(&crop->basetemp,swap,file);
  freadint1(&crop->senescence,swap,file);
  freadint1(&crop->senescence0,swap,file);
  freadreal1(&crop->husum,swap,file);
  freadreal1(&crop->vdsum,swap,file);
  freadreal1(&crop->fphu,swap,file);
  freadreal((Real *)&crop->ind,sizeof(Cropphys2)/sizeof(Real),swap,file);
  freadreal1(&crop->lai,swap,file);
  freadreal1(&crop->lai000,swap,file);
  freadreal1(&crop->laimax_adjusted,swap,file);
  freadreal1(&crop->lai_nppdeficit,swap,file);
  freadreal1(&crop->demandsum,swap,file);
  freadreal1(&crop->ndemandsum,swap,file);
  freadreal1(&crop->nuptakesum,swap,file);
  freadreal1(&crop->lgp,swap,file);
  freadreal1(&crop->nfertilizer,swap,file);
  freadreal1(&crop->vscal_sum,swap,file);
#ifdef DOUBLE_HARVEST
  freadreal1(&crop->supplysum,swap,file);
  freadreal1(&crop->petsum,swap,file);
  freadreal1(&crop->evapsum,swap,file);
  freadreal1(&crop->transpsum,swap,file);
  freadreal1(&crop->intercsum,swap,file);
  freadreal1(&crop->precsum,swap,file);
  freadreal1(&crop->sradsum,swap,file);
  freadreal1(&crop->pirrww,swap,file);
  freadreal1(&crop->tempsum,swap,file);
  freadreal1(&crop->nirsum,swap,file);
  freadint1(&crop->sdate,swap,file);
  return freadint1(&crop->sowing_year,swap,file)!=1;
#else
  return freadreal1(&crop->supplysum,swap,file)!=1;
#endif
} /* of 'fread_crop' */
