/***************************************************************************/
/**                                                                       **/
/**       f   i   n   d   c  f   t   .   c                                **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran/C++ version     **/
/**                                                                       **/
/**     Function of NPP update of agriculture stand                       **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     See file AUTHORS for list of authors contributing to this code    **/
/**                                                                       **/
/**     Last change: $Date:: 2019-02-15 15:24:34 +0100 (Fri, 15 Feb 201#$ **/
/**     By         : $Author:: felutz                          $          **/
/**                                                                       **/
/***************************************************************************/

#include "lpj.h"
#include "crop.h"
#include "natural.h"
#include "agriculture.h"


Bool findcft(const Stand *stand, const char *name)
{
  const Pft *pft;
  int p;
  foreachpft(pft, p, &stand->pftlist)
    if (!strcmp(pft->par->name, name))
      return TRUE;
  return FALSE;
}