/***************************************************************************/
/**                                                                       **/
/**                    p  f  t  l  i  s  t  .  h                          **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2016-10-26 14:56:14 +0200 (Wed, 26 Oct 201#$ **/
/**     By         : $Author:: cmueller                        $          **/
/**                                                                       **/
/***************************************************************************/

#ifndef PFTLIST_H /* Already included? */
#define PFTLIST_H

/* Definition of datatypes */

typedef struct
{
  Pft *pft; /* PFT array */
  int n;    /* size of PFT array */
} Pftlist;

/* Declaration of functions */

extern int delpft(Pftlist *,int);
extern void freepftlist(Pftlist *);
extern Real gp_sum(Pftlist *,Real,Real,Real,Real,Real *,Real [],Real *,int);
extern Real fpc_sum(Real [],int,const Pftlist *);
extern int fwritepftlist(FILE *,const Pftlist *);
extern void fprintpftlist(FILE *,const Pftlist *);
extern Bool freadpftlist(FILE *,struct stand *,Pftlist *,const Pftpar[],int,
                         Bool);
extern Stocks firepft(Litter *,Pftlist *,Real);
extern void newpftlist(Pftlist *);
extern int addpft(struct stand *,const Pftpar *,int,int);

/* Definitions of macros */

#define getpft(pftlist,i) ((pftlist)->pft+(i))
#define foreachpft(pft,i,pftlist) for(i=0;i<getnpft(pftlist) && (pft=getpft(pftlist,i));i++)
#define getnpft(pftlist) (pftlist)->n
#define printpftlist(pftlist) fprintpftlist(stdout,pftlist)

#endif
