/***************************************************************************/
/**                                                                       **/
/**                   g  r  a  s  s  .  h                                 **/
/**                                                                       **/
/**     C implementation of LPJ, derived from the Fortran version         **/
/**                                                                       **/
/**     Header file for grass PFTs                                        **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2017-02-23 12:38:53 +0100 (Thu, 23 Feb 201#$ **/
/**     By         : $Author:: bloh                            $          **/
/**                                                                       **/
/***************************************************************************/

#ifndef GRASS_H /* Already included? */
#define GRASS_H


/* Definition of datatypes */

typedef struct
{
  Real leaf,root;
} Grassphyspar;

typedef struct
{
  Stocks leaf,root;
} Grassphys;

typedef struct
{
  Grassphyspar turnover; /* turnover period (years) (9,11,12) */
  Grassphyspar cn_ratio; /* C:N mass ratio (13-15) */
  Real ratio;            /* C:N ratio of roots relative to leaf */
  Grassphys sapl;        /* sapling */
  Real sapling_C;	 /* sapling C (gC/m2) */
  Real reprod_cost;      /* reproduction cost */
} Pftgrasspar;

typedef struct
{
  Grassphys turn;
#ifdef NEW_GRASS
  Real max_leaf;
#endif
  Real excess_carbon;
  Grassphys ind;
  Grassphyspar falloc;
} Pftgrass;

/* Declaration of functions */

extern void new_grass(Pft *,int,int);
extern Real npp_grass(Pft *,Real,Real,Real,Bool);
extern Real fpc_grass(Pft *);
extern Real fpar_grass(const Pft *);
extern Real alphaa_grass(const Pft *,int);
extern void litter_update_grass(Litter *, Pft*,Real);
#ifdef NEW_GRASS
extern void output_daily_grass(Daily_outputs *,const Pft *,Real, Real); 
extern Harvest harvest_stand_grass(Output *,Stand *,int);
#else
extern void output_daily_grass(Daily_outputs *,const Pft *); 
#endif
extern Bool allocation_grass(Litter *,Pft *,Real *);
extern Real lai_grass(const Pft *);
extern Real actual_lai_grass(const Pft *);
extern Stocks turnover_grass(Litter *,Pft *,Bool,Real);
extern void phenology_grass(Pft *,Real,int);
extern Bool fwrite_grass(FILE *,const Pft *);
extern void fprint_grass(FILE *,const Pft *);
extern Bool fread_grass(FILE *,Pft *,Bool);
extern Bool fscanpft_grass(FILE *,Pftpar *,Bool);
extern Stocks establishment_grass(Pft *,Real,Real,int);
extern Real vegc_sum_grass(const Pft *);
extern Real vegn_sum_grass(const Pft *);
extern void mix_veg_grass(Pft *,Real);
extern Stocks fire_grass(Pft *,Real *);
extern void init_grass(Pft *);
extern void free_grass(Pft *);
extern void light_grass(Litter *,Pft *,Real);
extern void reduce_grass(Litter *,Pft *,Real);
extern void fprintpar_grass(FILE *,const Pftpar *);
extern Stocks livefuel_consum_grass(Litter *,Pft *,const Fuel *,Livefuel *,
                                  Bool *,Real, Real);
extern Bool annual_grass(struct stand *,Pft *,Bool,Real *);
extern Harvest harvest_stand(Output *,Stand *,int,Bool,Real);
extern void turnover_monthly_grass(Litter *,Pft *);
extern void turnover_daily_grass(Litter *, Pft *, Real);
extern Real albedo_grass(const Pft *,Real,Real);
extern Real nuptake_grass(Soil *,Pft *,Real *,Real *,int,int,int);
extern Real ndemand_grass(const Pft *,Real *,Real,Real,Real,int,int,int);
extern Real vmaxlimit_grass(const Pft *,Real,Real);

/* Definition of macros */

#define isgrass(pft) (getpftpar(pft,type)==GRASS)
#define fprintgrassphys(file,phys) fprintf(file,"%.2f %.2f (gC/m2) %.2f %.2f (gN/m2)",phys.leaf.carbon,phys.root.carbon,phys.leaf.nitrogen,phys.root.nitrogen)
#define phys_sum_grass(ind) (ind.leaf.carbon+ind.root.carbon)
#define phys_sum_grass_n(ind) (ind.leaf.nitrogen+ind.root.nitrogen)

#endif
