/***************************************************************************/
/**                                                                       **/
/**                  c  o  n  f  .  h                                     **/
/**                                                                       **/
/**     Header for LPJ configuration file                                 **/
/**     Must be included by LPJmL configuration file                      **/
/**                                                                       **/
/**     written by Werner von Bloh, Sibyll Schaphoff                      **/
/**     Potsdam Institute for Climate Impact Research                     **/
/**     PO Box 60 12 03                                                   **/
/**     14412 Potsdam/Germany                                             **/
/**                                                                       **/
/**     Last change: $Date:: 2019-06-26 17:39:15 +0200 (Wed, 26 Jun 201#$ **/
/**     By         : $Author:: felutz                          $          **/
/**                                                                       **/
/***************************************************************************/

#ifndef CONF_H
#define CONF_H

#define LPJ 0          /* LPJ simulation with natural vegetation only */
#define LPJML 1        /* LPJ simulation with managed land */
#define LPJML_IMAGE 4  /* LPJ simulation with managed land coupled to IMAGE
                          model */
#define LPJML_FMS 5  /* LPJ simulation with managed land coupled to FMS */
#define LANDUSE 1
#define NO_LANDUSE 0
#define CONST_LANDUSE 3
#define ALL_CROPS 4
#define ONLY_CROPS 5
#define NO_FIXED_SDATE 0
#define FIXED_SDATE 1
#define PRESCRIBED_SDATE 2
#define NO_IRRIGATION 0
#define LIM_IRRIGATION 1
#define POT_IRRIGATION 2
#define ALL_IRRIGATION 3
#define GRASS_HARVEST_OPTIONS 1
#define NO_GRASS_HARVEST_OPTIONS 0
#define TILLAGE 1
#define NO_TILLAGE 0
#define GRASS_FIXED_PFT 1
#define NO_GRASS_FIXED_PFT 0
#define LAIMAX_CFT 0
#define LAIMAX_INTERPOLATE 1
#define CONST_LAI_MAX 2
#define LAIMAX_PAR 3
#define NO_RESERVOIR 0
#define RESERVOIR 1
#define NO_DRAINAGE 0
#define DRAINAGE 1
#define PERM 1
#define NO_PERM 0
#define NEW_PERC 1
#define OLD_PERC 0
#define NO_WATERUSE 0
#define WATERUSE 1
#define NO_NITROGEN 0
#define NITROGEN 1
#define NO_RWMANAGEMENT 0
#define RWMANAGEMENT 1
#define RADIATION_LWDOWN 3
#define RADIATION_SWONLY 2
#define RADIATION 1
#define CLOUDINESS 0
#define ALL -1
#define RAW 0
#define CLM 1
#define CLM2 2
#define TXT 3
#define FMS 4
#define CDF 5
#define RESTART 1
#define NO_RESTART 0
#define NO_FIRE 0
#define FIRE 1
#define SPITFIRE 2
#define OLD_PHENOLOGY 0
#define NEW_PHENOLOGY 1
#define NO_POPULATION 0
#define POPULATION 1
#define NO_FIREWOOD 0
#define FIREWOOD 1
#define RANDOM_PREC 1
#define INTERPOLATE_PREC 0
#define NOUT 280            /* number of output files */
#define END -1              /* end marker for output files */
#define GRIDBASED 1         /* pft-specific outputs scaled by stand->frac */
#define PFTBASED 0          /* pft-specific outputs not scaled by stand->frac */
#define DAILY_IRRIG 1       /* daily outputs for irrigated crop */
#define DAILY_RAINFED 0     /* daily outputs for rain-fed crop */
#define CONST_PREC 2
/*monthly and annual output*/
#define GRID 0          
#define FPC 1          
#define MNPP 2          
#define MGPP 3          
#define MRH 4          
#define MTRANSP 5          
#define MRUNOFF 6          
#define MDISCHARGE 7          
#define MEVAP 8          
#define MINTERC 9          
#define MSWC1 10          
#define MSWC2 11          
#define FIREC 12          
#define FIREF 13          
#define VEGC 14          
#define SOILC 15          
#define LITC 16          
#define FLUX_ESTABC 17          
#define PFT_NPP 18          
#define PFT_GCGP 19          
#define HARVESTC 20          
#define MIRRIG 21          
#define SDATE 22          
#define PFT_HARVESTC 23          
#define PFT_RHARVESTC 24          
#define COUNTRY 25          
#define REGION 26          
#define MG_VEGC 27          
#define MG_SOILC 28
#define MG_LITC 29          
#define APREC 30          
#define INPUT_LAKE 31          
#define MRETURN_FLOW_B 32          
#define MEVAP_LAKE 33          
#define ADISCHARGE 34          
#define CFTFRAC 35          
#define CFT_CONSUMP_WATER_G 36          
#define CFT_CONSUMP_WATER_B 37          
#define PROD_TURNOVER 38          
#define DEFOREST_EMIS 39          
#define AIRRIG 40          
#define CFT_AIRRIG 41          
#define HDATE 42          
#define GROWING_PERIOD 43          
#define CFT_PET 44          
#define CFT_TRANSP 45          
#define CFT_EVAP 46          
#define CFT_INTERC 47          
#define CFT_NIR 48          
#define CFT_TEMP 49          
#define CFT_PREC 50
/* daily outputs for single crops */      
#define D_LAI 51          
#define D_PHEN 52          
#define D_CLEAF 53          
#define D_CROOT 54          
#define D_CSO 55          
#define D_CPOOL 56          
#define D_WDF 57          
#define D_GROWINGDAY 58          
#define D_PVD 59          
#define D_PHU 60          
#define D_FPHU 61          
#define D_LAIMAXAD 62          
#define D_LAINPPDEF 63          
#define D_HUSUM 64          
#define D_VDSUM 65          
#define D_WSCAL 66          
#define D_NPP 67          
#define D_GPP 68          
#define D_RD 69          
#define D_RROOT 70          
#define D_RSO 71          
#define D_RPOOL 72          
#define D_GRESP 73          
#define D_TRANS 74          
#define D_EVAP 75          
#define D_PREC 76          
#define D_PERC 77          
#define D_IRRIG 78          
#define D_W0 79          
#define D_W1 80          
#define D_WEVAP 81
#define D_LITTER_AGSUB 82
#define D_LITTER_AG 83
#define D_LITTER_COVER 84 
#define D_LITTER_AGTEMP 85 
#define D_LITTER_AGMOIST 86 
#define D_LITTER_AGDECOMP 87 
#define D_LITTER_EVAP 88 
#define D_WHC 89 
#define D_WSAT 90 
#define D_KSAT 91 
#define D_FC 92 
#define D_WP 93 
#define D_HI 94 
#define D_FHIOPT 95 
#define D_HIMIND 96 
#define D_FROOT 97 
#define D_TEMP 98 
#define D_SUN 99 
#define D_PAR 100 
#define D_DAYLENGTH 101 
#define D_SWE 102 
#define D_DISCHARGE 103 
#define D_RUNOFF 104 
#define D_RH 105 
#define D_INTERC 106 
#define D_NUPTAKE 107 
#define D_N2O_DENIT 108 
#define D_N2O_NIT 109 
#define D_N2_DENIT 110 
#define D_LEACHING 111 
#define D_BNF 112 
#define D_NLEAF 113 
#define D_NROOT 114 
#define D_NSO 115 
#define D_NPOOL 116 
#define D_NO3 117 
#define D_NH4 118 
#define D_NSOIL_SLOW 119 
#define D_NSOIL_FAST 120 
#define D_ASSIM 121 
#define D_ROT_MODE 122 
#define D_NLIMIT 123 
#define D_VSCAL 124 
#define D_NMIN 125 
#define D_NIMMO 126 
#define D_FW0 127 
#define D_FW1 128 
#define D_FWEVAP 129 
#define D_PET 130 /* last daily output ID; Insert additional output before! */
#define MEVAP_RES 131 
#define MPREC_RES 132 
#define MFIREC 133 
#define MNFIRE 134 
#define MFIREDI 135 
#define MFIREEMISSION 136 
#define MFPAR 137 
#define FLUX_FIREWOOD 138 
#define RHARVEST_BURNTC 139 
#define RHARVEST_BURNT_IN_FIELDC 140 
#define MTEMP_IMAGE 141 
#define MPREC_IMAGE 142 
#define MSUN_IMAGE 143 
#define MWET_IMAGE 144 
#define FBURN 145 
#define FTIMBER 146 
#define TIMBER_HARVEST 147 
#define PRODUCT_POOL_FAST 148 
#define PRODUCT_POOL_SLOW 149 
#define LUC_IMAGE 150 
#define MAXTHAW_DEPTH 151 
#define MSOILTEMP1 152 
#define MSOILTEMP2 153 
#define MSOILTEMP3 154 
#define MSOILTEMP4 155 
#define MSOILTEMP5 156 
#define MSOILTEMP6 157 
#define MRES_STORAGE 158 
#define MRES_DEMAND 159 
#define MTARGET_RELEASE 160 
#define MRES_CAP 161 
#define SEASONALITY 162 
#define MPET 163 
#define TRAD_BIOFUEL 164 
#define AFRAC_WD_UNSUST 165 
#define MWD_UNSUST 166 
#define ACONV_LOSS_EVAP 167 
#define MWD_LOCAL 168 
#define MWD_NEIGHB 169 
#define MWD_RES 170 
#define MWD_RETURN 171 
#define MCONV_LOSS_EVAP 172 
#define MPREC 173 
#define MRAIN 174 
#define MSNOWF 175 
#define MMELT 176 
#define MSNOWRUNOFF 177 
#define MSWE 178 
#define SOILC_LAYER 179 
#define MRUNOFF_SURF 180 
#define MRUNOFF_LAT 181 
#define MSEEPAGE 182 
#define MBURNTAREA 183 
#define SOILC_SLOW 184 
#define MSWC3 185 
#define MSWC4 186 
#define MSWC5 187 
#define MROOTMOIST 188 
#define CFT_SRAD 189 
#define CFT_ABOVEGBMC 190 
#define MGCONS_RF 191 
#define MGCONS_IRR 192 
#define MBCONS_IRR 193 
#define AWATERUSE_HIL 194 
#define MWATERAMOUNT 195 
#define CFT_ABOVEGBMN 196 
#define PFT_HARVESTN 197 
#define PFT_RHARVESTN 198 
#define RHARVEST_BURNTN 199 
#define RHARVEST_BURNT_IN_FIELDN 200 
#define FLUX_ESTABN 201 
#define VEGN 202 
#define SOILN 203 
#define LITN 204 
#define SOILNH4 205 
#define SOILNO3 206 
#define HARVESTN 207 
#define SOILN_LAYER 208 
#define SOILN_SLOW 209 
#define PFT_NUPTAKE 210 
#define MNUPTAKE 211 
#define MLEACHING 212 
#define MN2O_DENIT 213 
#define MN2O_NIT 214 
#define MN2_EMIS 215 
#define MBNF 216 
#define PFT_NDEMAND 217 
#define MN_MINERALIZATION 218 
#define FIREN 219 
#define MN_IMMO 220 
#define PFT_CLEAF 221 
#define PFT_NLEAF 222 
#define PFT_VEGC 223 
#define PFT_VEGN 224 
#define MIRRIG_RW 225 
#define MTRANSP_B 226 
#define CFT_TRANSP_B 227 
#define MUNMET_DEMAND 228 
#define CFT_FPAR 229 
#define MEVAP_B 230 
#define MINTERC_B 231 
#define CFT_EVAP_B 232 
#define CFT_INTERC_B 233 
#define CFT_RETURN_FLOW_B 234 
#define CFT_IRRIG_EVENTS 235 
#define CFT_CONV_LOSS_EVAP 236 
#define CFT_CONV_LOSS_DRAIN 237 
#define MSTOR_RETURN 238 
#define MCONV_LOSS_DRAIN 239 
#define ACONV_LOSS_DRAIN 240 
#define NEGN_FLUXES 241 
#define NEGC_FLUXES 242 
#define PFT_LAIMAX 243 
#define PFT_CROOT 244 
#define PFT_NROOT 245 
#define PFT_CSAPW 246 
#define PFT_NSAPW 247 
#define PFT_CHAWO 248 
#define PFT_NHAWO 249 
#define HDATE2 250 
#define SDATE2 251 
#define PFT_HARVESTC2 252 
#define PFT_RHARVESTC2 253 
#define GROWING_PERIOD2 254 
#define CFT_PET2 255 
#define CFT_TRANSP2 256 
#define CFT_EVAP2 257 
#define CFT_INTERC2 258 
#define CFT_NIR2 259 
#define CFT_TEMP2 260 
#define CFT_PREC2 261 
#define CFT_SRAD2 262 
#define CFT_ABOVEGBMC2 263 
#define CFTFRAC2 264 
#define CFT_AIRRIG2 265 
#define SYEAR 266 
#define SYEAR2 267 
#define PFT_HARVESTN2 268 
#define PFT_RHARVESTN2 269 
#define CFT_ABOVEGBMN2 270 
#define MN_VOLATILIZATION 271 
#define PFT_NLIMIT 272 
#define SOILNO3_LAYER 273 
#define SOILNH4_LAYER 274 
#define MMG_SOILC 275 
#define RUNOFF_SURF 276 
#define RUNOFF_LAT 277 
#define LITC_ALL 278 
#define LITC_AG 279 

#define RANDOM_SEED 0 

#endif 


