rm(list=ls(all=TRUE))

##############################################################################################
#  Script by Femke Lutz (12.2019) for:                                                      ##
# "The importance of management information and soil moisture representation for            ##
#  simulating tillage effects on N$_2$O emissions in LPJmL5.0-tillage                       ##
#                                                                                           ##
#  preprocesses data to create dataframes nit_denit_all and waterframe. uses dataframe      ##
#   created in read.runs.R                                                                  ##
#                                                                                           ##
##############################################################################################

#General Settings
#Add working path /.../
working.path<-""
sites<- c("colorado","nebraska","boigneville","michigan")
day.path<-"/p/projects/macmit/users/felutz/daycent_comparison/daycent/"

#names output files Daycent
dc.mgtn_ct<-c("nflux_cont_corn_7_ct","nflux_ct0rem",
              "nflux_france_ct","nflux_kbs1_new")
dc.mgtn_nt<-c("nflux_cont_corn_7_nt","nflux_nt0rem",
              "nflux_france_nt","nflux_kbs2_new")
dc.wfps_ct<-c("wfps_cont_corn_7_ct","wfps_ct0rem",
              "wfps_france_ct","wfps_kbs1_new")
dc.wfps_nt<-c("wfps_cont_corn_7_nt","wfps_nt0rem",
              "wfps_france_nt","wfps_kbs2_new")

#names output files LPJmL tillage
CT_vect<- c("output_till_detail","output_till_fert","output_till_irr",
            "output_till_gs","output_till_pz","output_till_till",
            "output_till_glob","Daycent_CT","Observed_CT","output_till_detail_adjusted","output_till_fert_adjusted","output_till_irr_adjusted",
            "output_till_gs_adjusted","output_till_pz_adjusted","output_till_till_adjusted",
            "output_till_glob_adjusted")

#names output files LPJmL no-tillage, and adjusted
NT_vect<- c("output_notill_detail","output_notill_fert","output_notill_irr",
            "output_notill_gs","output_notill_pz","output_notill_glob","output_notill_till",
            "Daycent_NT","Observed_NT","output_notill_detail_adjusted","output_notill_fert_adjusted","output_notill_irr_adjusted",
            "output_notill_gs_adjusted","output_notill_pz_adjusted","output_notill_glob_adjusted","output_notill_till_adjusted")
runs<-    c("LPJmL.D","Daycent.D")
adj_vect<- c("output_notill_detail_adjusted","output_notill_fert_adjusted","output_notill_irr_adjusted",
             "output_notill_gs_adjusted","output_notill_pz_adjusted","output_notill_glob_adjusted","output_notill_till_adjusted",
             "output_till_detail_adjusted","output_till_fert_adjusted","output_till_irr_adjusted",
             "output_till_gs_adjusted","output_till_pz_adjusted","output_till_glob_adjusted","output_till_till_adjusted")
#FUNCTIONS##########################################################################
#calulation of WSAT
wsat.bd<-function(bd){    #saturated water content(frac)=porosity (fraction)= 1-bulkdensity (g/cm3)/ soil particle density (g/cm3). soil
1-(bd/2.7)                #particle density is assumed to be 2.7 g/cm3 (as in pedotransfer.c).
}

#removing 29th of feb in leap year daycent

dates_dc<- function(df.daycent){
  df.daycent$year<-floor(df.daycent$time)
  df.daycent$date<- as.character(as.Date(df.daycent$dayofyr-1,origin=
                                           paste0(as.character(df.daycent$year),"-01-01")))
  df.daycent$date<- as.Date(df.daycent$date)
  df.daycent$month <-as.numeric(format(df.daycent$date, "%m"))
  df.daycent$dayofmonth<-as.numeric(format(df.daycent$date, "%d"))
  
  #remove leapyears from daycent file
  leap_years <- df.daycent$year[which(df.daycent$month==2 & df.daycent$dayofmonth==29)] # find leap years
  cut_feb29 <- which(df.daycent$year %in% leap_years & df.daycent$month==2 & df.daycent$dayofmonth==29) # feb 29 of leap years
  df.daycent <- df.daycent[-cut_feb29,] # omit feb29 of leap years, to be changed when growing season is overlappi  
}
##################################################################################
#Reading in Daycent simulations on water, calculate relative FC and WP to porosity#
##################################################################################
#read in wfps
dc_wfps<-NULL
for(i in 1:length(sites)){
  if(i==3){sites[i]<-"france"}
  pad<- paste0(day.path,sites[i],"/",dc.wfps_ct[i],".out")
  dayc<-read.table(pad,header=F)
  if(i==3){sites[i]<-"boigneville"}
  dayc$site<-sites[i]
  dayc$till.type<-"Conv. tillage"
  colnames(dayc)[1:8]<- c("time","dayofyr","layer1",
                          "layer2","layer3","layer4","layer5","layer6")
  if(i==2){dayc<-dayc[,-16]}
  dc_wfps<-rbind(dc_wfps,dayc)
}

for(i in 1:length(sites)){
  if(i==3){sites[i]<-"france"}
  pad<- paste0(day.path,sites[i],"/",dc.wfps_nt[i],".out")
  dayc<-read.table(pad,header=F)
  if(i==3){sites[i]<-"boigneville"}
  dayc$site<-sites[i]
  dayc$till.type<-"No tillage"
  colnames(dayc)[1:8]<- c("time","dayofyr","layer1",
                          "layer2","layer3","layer4","layer5","layer6")
  if(i==2){dayc<-dayc[,-16]}
  dc_wfps<-rbind(dc_wfps,dayc)
}

dayc.hydr<- data.frame(matrix(ncol=4,nrow=length(sites)))
colnames(dayc.hydr)<-c("site","d_fc","d_wp","bd")
dayc.hydr$site<-sites #col,neb,boign,mich
dayc.hydr$d_fc<- c(0.33791,0.36490,0.31994,0.26791) #field capacity
dayc.hydr$d_wp<- c(0.19023,0.14143,0.13847,0.12723) #wilting point
dayc.hydr$bd<- c(1.395,1.19,1.44425,1.535) #bulk density
dayc.hydr$wsat<-wsat.bd(dayc.hydr$bd) #saturation
#fc and wp relative to wfps as in daycent
dayc.hydr$d_fc<- dayc.hydr$d_fc/dayc.hydr$wsat
dayc.hydr$d_wp<- dayc.hydr$d_wp/dayc.hydr$wsat
dayc.hydr<-dayc.hydr[,c(1:3)] #d_fc, d_wp

#Daycent wfps
dc_wfps$"0-20layer"<- ((0.1*dc_wfps$layer1)+(0.15*dc_wfps$layer2)+(0.25*dc_wfps$layer3)+(0.5*dc_wfps$layer4))
dc_wfps$"20-50layer"<- ((0.4*dc_wfps$layer5)+(0.6*dc_wfps$layer6))
day_water<-NULL
for(i in 1:length(sites)){
  sit.water<-subset(dc_wfps,dc_wfps$site==sites[i])
  sit_wfps<-dates_dc(sit.water)
  day_water<-rbind(day_water,sit_wfps)
}

day_water$run<-"Daycent.D"
day_water$adj.type<-"Daycent.D"
day_water<-day_water[,c(20,21,24,16,17,18,19,25)] #year,date,run,site,till.type, 0-20.20-50,ad.type
day_water_fc<-merge(day_water,dayc.hydr,by=c("site"))
day_water_fc<-day_water_fc[,c(2:4,1,5:9)]
colnames(day_water_fc)[9]<-"Property"
day_water_fc$Hydr.prop<-"Field Capacity"
day_water_wp<-merge(day_water,dayc.hydr,by=c("site"))
day_water_wp<-day_water_wp[,c(2:4,1,5:8,10)]
colnames(day_water_wp)[9]<-"Property"
day_water_wp$Hydr.prop<-"Wilting Point"
day_water<-rbind(day_water_fc,day_water_wp)
rm(day_water_fc,day_water_wp)

##################################################################################
#Reading in Observation                                                     ######
##################################################################################
#Tillage observed
obs_ct<-NULL
for(i in c(1,2)){
  o.ct<-get(load(paste0(working.path,sites[i],"/","water_obs_ct",".RData"))) #add path
  o.ct$till.type<- "Conv. tillage"
  o.ct$run<-"Observed"
  o.ct$site<- sites[i]
  obs_ct<-rbind(obs_ct,o.ct)
}

#No-tillage observed
obs_nt<-NULL
for(i in c(1,2)){
  o.nt<-get(load(paste0(working.path,sites[i],"/","water_obs_nt",".RData"))) #add path
  o.nt$till.type<- "No tillage"
  o.nt$run<-"Observed"
  o.nt$site<- sites[i]
  obs_nt<-rbind(obs_nt,o.nt)
}

#combine tillage and no-tillage observed water information to one dataframe
obs.water<-rbind(obs_ct,obs_nt)
xx<-which(is.na(obs.water$water_frac))
obs.water<-obs.water[-xx,]
obs.water$wsat<- 1-(obs.water$bd_15/2.7) #assuming mineral density is 2.7
#WFPS
obs.water$"0-20layer"<- obs.water$water_frac/obs.water$wsat
obs.water$"20-50layer"<-NA
obs.water$adj.type<- "Obs."
obs.water<-obs.water[,c(3,1,6,7,5,9,10,11)]
colnames(obs.water)[2]<-"date"
obs.water$Property<-NA
obs.water$Hydr.prop<-NA

##################################################################################
#Reading in Daycent simulations on nitrification and denitrification #############
##################################################################################
#read in nflux.out
dc_nflux<-NULL
for(i in 1:length(sites)){
if(i==3){sites[i]<-"france"}
pad<- paste0(day.path,sites[i],"/",dc.mgtn_ct[i],".out")
dayc<-read.table(pad,header=T)
if(i==3){sites[i]<-"boigneville"}
dayc$site<-sites[i]
dayc$till.type<-"Conv. tillage"
dc_nflux<-rbind(dc_nflux,dayc)
}

for(i in 1:length(sites)){
  if(i==3){sites[i]<-"france"}
  pad<- paste0(day.path,sites[i],"/",dc.mgtn_nt[i],".out")
  dayc<-read.table(pad,header=T)
  if(i==3){sites[i]<-"boigneville"}
  dayc$site<-sites[i]
  dayc$till.type<-"No tillage"
  dc_nflux<-rbind(dc_nflux,dayc)
}

##################################################################################
#Reading in LPJml simulations on water, calculate relative FC and WP to porosity#
##################################################################################

full_lpj<-NULL
for(i in 1:length(sites)){
  lpj<-get(load(paste0(working.path,sites[i],"/","LPJML_entire",".RData"))) #add path
  lpj$site<-sites[i]
  full_lpj<-rbind(full_lpj,lpj)
}
full_lpj$till.type<- ifelse(full_lpj$run_ct_nt %in% NT_vect,"No tillage","Conv. tillage")
full_lpj$adj.type<- ifelse(full_lpj$run_ct_nt %in% adj_vect,"LPJmL.modified.","LPJmL.Orig")

#remove other outputs
lpj.water<-subset(full_lpj,select=c(year,date,d_wevap,d_w0,run_ct_nt,
                                    run,site,till.type,adj.type,d_whc,d_fc,d_wp))

lpj.water$run[which(lpj.water$run=="Detail")]<-"LPJmL.D"
lpj.water<-subset(lpj.water,lpj.water$run=="LPJmL.D")

#To compute volumetric water content, simply divide by soil layer depth (200, 300 and 500 mm, respectively).

lpj.water$"0-20layer"<-lpj.water$d_wevap
lpj.water$"20-50layer"<-lpj.water$d_w0
lpj.water_d_wp<-lpj.water[,c(1,2,6,7,8,13,14,9,12)]#year,date,run,site,tilltype,0-20
                                            #20-50,adj.type,whc,fc,wp
lpj.water_d_wp$Hydr.prop<-"Wilting Point"
colnames(lpj.water_d_wp)[9]<-"Property"
lpj.water_d_fc<-lpj.water[,c(1,2,6,7,8,13,14,9,11)]#
lpj.water_d_fc$Hydr.prop<-"Field Capacity"
colnames(lpj.water_d_fc)[9]<-"Property"
lpj.water<-rbind(lpj.water_d_fc,lpj.water_d_wp)
rm(lpj.water_d_fc,lpj.water_d_wp)

#Combine dataframes of Daycent, observations and LPJmL to 1 dataframe for water
water.frame<-rbind(lpj.water,day_water,obs.water)
colnames(water.frame)[6]<-"first_layer"
colnames(water.frame)[7]<-"second_layer"
water.frame$border<-ifelse(water.frame$run %in% runs,"Run","Observed")
water.frame$border<- factor(water.frame$border)
water.frame$adj.type<- factor(water.frame$adj.type)
water.frame$run<-factor(water.frame$run)

water.frame$Hydr.prop<-factor(water.frame$Hydr.prop)

rm(obs.water,xx,o.nt,o.ct,
   day_water,lpj.water)

#####WATER PLOT######
save(water.frame,file=paste0(working.path,"waterframe",".RData"))


#N2O from (de)nitrification
#Observations are not available for seperate processes (nit/denit)
#nit and denit n2o has to be converted to g ha in lpj
#remove other outputs
lpj.n2o<-subset(full_lpj,select=c(year,date,run,site,till.type,adj.type,
                                  d_n2o_nit, d_n2o_denit))

#lpj.n2o<-subset(lpj.n2o,lpj.n2o$run=="LPJmL.D")
lpj.n2o$n2o_nit<-lpj.n2o$d_n2o_nit*10000 
lpj.n2o$n2o_denit<-lpj.n2o$d_n2o_denit*10000 

#daycent
day.n2o<-NULL
for(i in 1:length(sites)){
sit<-subset(dc_nflux,dc_nflux$site==sites[i])
sit_flux<-dates_dc(sit)
sit_flux$n2o_nit<-sit_flux$nit_N2O.N #is already in g ha
sit_flux$n2o_denit<-sit_flux$dnit_N2O.N #is already in g ha
day.n2o<-rbind(day.n2o,sit_flux)
}
day.n2o$run<-"Daycent.D"
day.n2o$adj.type<-"Daycent.D"
day.n2o<- subset(day.n2o,select=c("year","date","run","site","till.type",
                                  "adj.type","n2o_nit","n2o_denit"))
lpj.n2o<-subset(lpj.n2o, select= -c(d_n2o_nit,d_n2o_denit))

nit_denit<-rbind(lpj.n2o,day.n2o) #year,date,run,site,till.type,adj.type,n2o_nit, n2o_denit
save(nit_denit,file=paste0(working.path,"nit_denit_all",".RData"))




