# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
sys.path.insert(0, os.path.abspath('../..'))

on_rtd = os.environ.get("READTHEDOCS", None) == "True"
if not on_rtd:
    import sphinx_rtd_theme
    html_theme = "sphinx_rtd_theme"
    html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]


# -- Project information -----------------------------------------------------

master_doc = 'index'
project = 'widgyts'
copyright = '2019, Madicken Munk, Matthew Turk'
author = 'Madicken Munk, Matthew Turk'

# The full version, including alpha/beta/rc tags
# release = '0.3.1'

_release = {}
exec(compile(open('../../widgyts/_version.py').read(), '../../widgyts/_version.py', 'exec'), _release)
# version = '.'.join(map(str, _release['version_info'][:2]))
version = '.'.join(map(str, _release['version_info']))
release = _release['__version__']

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    'nbsphinx',
    'jupyter_sphinx.execute',
    'IPython.sphinxext.ipython_console_highlighting',
]

nbsphinx_allow_errors = True   # exception ipstruct.py ipython_genutils

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']
